/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json;

import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.json.comparator.Comparators;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.mapping.UserMapper;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserContact {
    public static final String ALL_ATTRIBUTES = "*";
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UserContact.class));
    private final User user;
    private final Contact contact;

    public UserContact(Contact contact, User user) {
        this.contact = contact;
        this.user = user;
    }

    private JSONObject serialize(Session session, ContactField[] contactFields, UserField[] userFields, String timeZoneID) throws OXException {
        JSONObject jsonObject = new JSONObject();
        try {
            ContactMapper.getInstance().serialize((Object)this.contact, jsonObject, (Enum[])contactFields, timeZoneID, session);
            UserMapper.getInstance().serialize(this.user, jsonObject, userFields, timeZoneID, session);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        return jsonObject;
    }

    public JSONObject serialize(String timeZoneID, Session session) throws OXException {
        JSONObject jsonObject = null;
        try {
            ContactField[] contactFields = ContactMapper.getInstance().getAssignedFields(this.contact, new ContactField[]{ContactField.NUMBER_OF_IMAGES});
            jsonObject = ContactMapper.getInstance().serialize((Object)this.contact, (Enum[])contactFields, timeZoneID, session);
            Enum[] userFields = (UserField[])UserMapper.getInstance().getAssignedFields(this.user);
            UserMapper.getInstance().serialize(this.user, jsonObject, userFields, timeZoneID);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException x) {
            System.out.print(x.getMessage());
        }
        return jsonObject;
    }

    public JSONArray serialize(Session session, int[] columnIDs, String timeZoneID, Map<String, List<String>> attributeParameters) throws OXException {
        JSONArray jsonArray = new JSONArray();
        UserField[] userFields = (UserField[])UserMapper.getInstance().getFields(columnIDs);
        ContactField[] contactFields = (ContactField[])ContactMapper.getInstance().getFields(columnIDs);
        JSONObject temp = this.serialize(session, contactFields, userFields, timeZoneID);
        for (int columnID : columnIDs) {
            UserField userField = (UserField)UserMapper.getInstance().getMappedField(columnID);
            if (null != userField) {
                String ajaxName = UserMapper.getInstance().get(userField).getAjaxName();
                jsonArray.put(temp.opt(ajaxName));
                continue;
            }
            ContactField contactField = (ContactField)ContactMapper.getInstance().getMappedField(columnID);
            if (null != contactField) {
                String ajaxName = ContactMapper.getInstance().get((Enum)contactField).getAjaxName();
                jsonArray.put(temp.opt(ajaxName));
                continue;
            }
            LOG.warn((Object)("Unknown field: " + columnID), new Throwable());
            jsonArray.put(JSONObject.NULL);
        }
        if (null != attributeParameters && 0 < attributeParameters.size()) {
            try {
                for (Map.Entry<String, List<String>> entry : attributeParameters.entrySet()) {
                    this.appendUserAttribute(jsonArray, entry.getKey(), entry.getValue());
                }
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return jsonArray;
    }

    private void appendUserAttribute(JSONArray jsonArray, String attributePrefix, List<String> attributes) throws JSONException {
        if (null != attributes && 0 < attributes.size()) {
            Map userAttributes = this.user.getAttributes();
            if (1 == attributes.size() && ALL_ATTRIBUTES.equals(attributes.get(0))) {
                if (null == userAttributes || userAttributes.isEmpty()) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    JSONObject jsonObject = new JSONObject();
                    for (Map.Entry entry : userAttributes.entrySet()) {
                        if (!((String)entry.getKey()).startsWith(attributePrefix)) continue;
                        jsonObject.put((String)entry.getKey(), UserContact.toJSONValue((Set)entry.getValue()));
                    }
                    jsonArray.put((Object)jsonObject);
                }
            } else {
                for (String attribute : attributes) {
                    String attributeName = String.format("%s/%s", attributePrefix, attribute);
                    jsonArray.put(UserContact.toJSONValue((Set)this.user.getAttributes().get(attributeName)));
                }
            }
        }
    }

    private static Object toJSONValue(Set<String> values) {
        if (null == values || values.isEmpty()) {
            return JSONObject.NULL;
        }
        if (values.size() > 1) {
            JSONArray ja = new JSONArray();
            for (String value : values) {
                ja.put((Object)value);
            }
            return ja;
        }
        return values.iterator().next();
    }

    public static Comparator<UserContact> getComparator(UserField userField, Locale sessionLocale, boolean descending) {
        final Comparator<User> userComparator = Comparators.getComparator(userField, sessionLocale, descending);
        return new Comparator<UserContact>(){

            @Override
            public int compare(UserContact o1, UserContact o2) {
                return userComparator.compare(o1.user, o2.user);
            }
        };
    }
}

