/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Filter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Charsets;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAware;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeHeaderNameChecker;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.MimeMessageDataSource;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.TextProcessing;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.session.Session;
import com.openexchange.smtp.SMTPCapabilityCache;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.MailAccountSMTPProperties;
import com.openexchange.smtp.config.SMTPConfig;
import com.openexchange.smtp.config.SMTPSessionProperties;
import com.openexchange.smtp.filler.SMTPMessageFiller;
import com.openexchange.smtp.services.SMTPServiceRegistry;
import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import com.sun.mail.smtp.SMTPMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.idn.IDNA;
import javax.security.auth.Subject;

public final class SMTPTransport
extends MailTransport {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(SMTPTransport.class));
    private static final String SMTP = SMTPProvider.PROTOCOL_SMTP.getName();
    private static final String KERBEROS_SESSION_SUBJECT = "kerberosSubject";
    private static volatile String staticHostName;
    private static volatile UnknownHostException warnSpam;
    private final Queue<Runnable> pendingInvocations;
    private volatile javax.mail.Session smtpSession;
    private final int accountId;
    private final Session session;
    private transient Subject kerberosSubject;
    private final Context ctx;
    private final UserSettingMail usm;
    private volatile SMTPConfig cachedSmtpConfig;
    private static final String ACK_TEXT = "Reporting-UA: OPEN-XCHANGE - WebMail\r\nFinal-Recipient: rfc822; #FROM#\r\nOriginal-Message-ID: #MSG ID#\r\nDisposition: manual-action/MDN-sent-manually; displayed\r\n";
    private static final String CT_TEXT_PLAIN = "text/plain; charset=#CS#";
    private static final String CT_READ_ACK = "message/disposition-notification; name=MDNPart1.txt; charset=UTF-8";
    private static final String CD_READ_ACK = "attachment; filename=MDNPart1.txt";
    private static final String MULTI_SUBTYPE_REPORT = "report; report-type=disposition-notification";

    protected SMTPTransport() {
        this.accountId = 0;
        this.smtpSession = null;
        this.session = null;
        this.ctx = null;
        this.usm = null;
        this.pendingInvocations = new Java7ConcurrentLinkedQueue();
    }

    public SMTPTransport(Session session) throws OXException {
        this(session, 0);
    }

    public SMTPTransport(Session session, int accountId) throws OXException {
        this.pendingInvocations = new ConcurrentLinkedQueue<Runnable>();
        this.session = session;
        this.accountId = accountId;
        if (session == null) {
            this.ctx = null;
            this.usm = null;
        } else {
            this.ctx = ContextStorage.getStorageContext((int)session.getContextId());
            this.usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), this.ctx);
        }
    }

    private void clearUp() {
        this.doInvocations();
    }

    public void close() {
        this.clearUp();
    }

    private void doInvocations() {
        Runnable task = this.pendingInvocations.poll();
        while (task != null) {
            task.run();
            task = this.pendingInvocations.poll();
        }
    }

    private void invokeLater(Runnable task) {
        this.pendingInvocations.offer(task);
    }

    private boolean isKerberosAuth() {
        return 0 == this.accountId && null != this.kerberosSubject;
    }

    private static void handlePrivilegedActionException(PrivilegedActionException e) throws MessagingException, OXException {
        if (null == e) {
            return;
        }
        Exception cause = e.getException();
        if (null == cause) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e.getCause(), new Object[]{e.getMessage()});
        }
        if (cause instanceof MessagingException) {
            throw (MessagingException)cause;
        }
        if (cause instanceof OXException) {
            throw (OXException)((Object)cause);
        }
        throw MailExceptionCode.UNEXPECTED_ERROR.create((Throwable)cause, new Object[]{cause.getMessage()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.mail.Session getSMTPSession() throws OXException {
        if (null == this.smtpSession) {
            SMTPTransport sMTPTransport = this;
            synchronized (sMTPTransport) {
                if (null == this.smtpSession) {
                    Properties smtpProps = SMTPSessionProperties.getDefaultSessionProperties();
                    SMTPConfig smtpConfig = this.getTransportConfig0();
                    ISMTPProperties smtpProperties = smtpConfig.getSMTPProperties();
                    this.kerberosSubject = (Subject)this.session.getParameter(KERBEROS_SESSION_SUBJECT);
                    boolean kerberosAuth = this.isKerberosAuth();
                    if (kerberosAuth) {
                        smtpProps.put("mail.smtp.auth", "true");
                        smtpProps.put("mail.smtp.sasl.enable", "true");
                        smtpProps.put("mail.smtp.sasl.authorizationid", smtpConfig.getLogin());
                        smtpProps.put("mail.smtp.sasl.mechanisms", kerberosAuth ? "GSSAPI" : "PLAIN");
                    } else {
                        smtpProps.put("mail.smtp.auth", smtpProperties.isSmtpAuth() ? "true" : "false");
                    }
                    String smtpLocalhost = smtpProperties.getSmtpLocalhost();
                    if (smtpLocalhost != null) {
                        smtpProps.put("mail.smtp.localhost", smtpLocalhost);
                    }
                    if (smtpProperties.getSmtpTimeout() > 0) {
                        smtpProps.put("mail.smtp.timeout", Integer.toString(smtpProperties.getSmtpTimeout()));
                    }
                    if (smtpProperties.getSmtpConnectionTimeout() > 0) {
                        smtpProps.put("mail.smtp.connectiontimeout", Integer.toString(smtpProperties.getSmtpConnectionTimeout()));
                    }
                    String sPort = String.valueOf(smtpConfig.getPort());
                    String socketFactoryClass = TrustAllSSLSocketFactory.class.getName();
                    if (smtpConfig.isSecure()) {
                        smtpProps.put("mail.smtp.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                    } else {
                        HostnameService hostnameService;
                        String hostName = smtpLocalhost;
                        if (null == hostName && null == (hostName = null == (hostnameService = (HostnameService)SMTPServiceRegistry.getServiceRegistry().getService(HostnameService.class)) ? SMTPTransport.getHostName() : hostnameService.getHostname(this.session.getUserId(), this.session.getContextId()))) {
                            hostName = SMTPTransport.getHostName();
                        }
                        try {
                            InetSocketAddress address = new InetSocketAddress(IDNA.toASCII((String)smtpConfig.getServer()), smtpConfig.getPort());
                            Map<String, String> capabilities = SMTPCapabilityCache.getCapabilities(address, smtpConfig.isSecure(), smtpProperties, hostName);
                            if (capabilities.containsKey("STARTTLS")) {
                                smtpProps.put("mail.smtp.starttls.enable", "true");
                            }
                        }
                        catch (IOException e) {
                            smtpProps.put("mail.smtp.starttls.enable", "true");
                        }
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.ssl.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.ssl.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                        smtpProps.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
                    }
                    this.smtpSession = javax.mail.Session.getInstance((Properties)smtpProps, null);
                }
            }
        }
        return this.smtpSession;
    }

    public SMTPConfig getTransportConfig() throws OXException {
        return this.getTransportConfig0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMTPConfig getTransportConfig0() throws OXException {
        SMTPConfig tmp = this.cachedSmtpConfig;
        if (tmp == null) {
            SMTPTransport sMTPTransport = this;
            synchronized (sMTPTransport) {
                tmp = this.cachedSmtpConfig;
                if (tmp == null) {
                    tmp = (SMTPConfig)TransportConfig.getTransportConfig((TransportConfig)new SMTPConfig(), (Session)this.session, (int)this.accountId);
                    tmp.setTransportProperties(this.createNewMailProperties());
                    this.cachedSmtpConfig = tmp;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReceiptAck(MailMessage srcMail, String fromAddr) throws OXException {
        if (null == srcMail) {
            return;
        }
        SMTPConfig smtpConfig = null;
        try {
            MailDateFormat mdf;
            String from;
            InternetAddress dispNotification = srcMail.getDispositionNotification();
            if (dispNotification == null) {
                throw SMTPExceptionCode.MISSING_NOTIFICATION_HEADER.create("Disposition-Notification-To", Long.valueOf(srcMail.getMailId()));
            }
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
            String userMail = UserStorage.getStorageUser((int)this.session.getUserId(), (Context)this.ctx).getMail();
            if (fromAddr == null) {
                if (this.usm.getSendAddr() == null && userMail == null) {
                    throw SMTPExceptionCode.NO_SEND_ADDRESS_FOUND.create();
                }
                from = this.usm.getSendAddr() == null ? userMail : this.usm.getSendAddr();
            } else {
                from = fromAddr;
            }
            smtpMessage.addFrom((Address[])MimeMessageUtility.parseAddressList((String)from, (boolean)false));
            Address[] recipients = new Address[]{dispNotification};
            SMTPTransport.checkRecipients(recipients);
            smtpMessage.addRecipients(Message.RecipientType.TO, recipients);
            smtpMessage.setHeader("X-Priority", "3 (normal)");
            smtpMessage.setHeader("Importance", "Medium");
            Locale locale = UserStorage.getStorageUser((int)this.session.getUserId(), (Context)this.ctx).getLocale();
            StringHelper strHelper = StringHelper.valueOf((Locale)locale);
            smtpMessage.setSubject(strHelper.getString("Read acknowledgement"));
            MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat((Session)this.session);
            synchronized (mailDateFormat) {
                smtpMessage.setHeader("Date", mdf.format(new Date()));
            }
            smtpConfig = this.getTransportConfig0();
            new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm).setAccountId(this.accountId).setCommonHeaders((MimeMessage)smtpMessage);
            String defaultMimeCS = MailProperties.getInstance().getDefaultMimeCharset();
            ContentType ct = new ContentType(CT_TEXT_PLAIN.replaceFirst("#CS#", defaultMimeCS));
            MimeMultipart mixedMultipart = new MimeMultipart(MULTI_SUBTYPE_REPORT);
            Date sentDate = srcMail.getSentDate();
            MimeBodyPart text = new MimeBodyPart();
            String txt = TextProcessing.performLineFolding((String)strHelper.getString("This is a delivery receipt for the mail that you sent on #DATE# to #RECIPIENT# with subject \"#SUBJECT#\".\n\nNote: This delivery receipt only acknowledges that the message was displayed on the recipients computer. There is no guarantee that the recipient has read or understood the message contents.").replaceFirst("#DATE#", sentDate == null ? "" : SMTPTransport.quoteReplacement(DateFormat.getDateInstance(1, locale).format(sentDate))).replaceFirst("#RECIPIENT#", SMTPTransport.quoteReplacement(from)).replaceFirst("#SUBJECT#", SMTPTransport.quoteReplacement(srcMail.getSubject())), (int)this.usm.getAutoLinebreak());
            MessageUtility.setText((String)txt, (String)defaultMimeCS, (Part)text);
            text.setHeader("MIME-Version", "1.0");
            text.setHeader("Content-Type", MimeMessageUtility.foldContentType((String)ct.toString()));
            mixedMultipart.addBodyPart((BodyPart)text);
            ct.setContentType(CT_READ_ACK);
            MimeBodyPart ack = new MimeBodyPart();
            String msgId = srcMail.getFirstHeader("Message-ID");
            String txt2 = strHelper.getString(ACK_TEXT).replaceFirst("#FROM#", SMTPTransport.quoteReplacement(from)).replaceFirst("#MSG ID#", SMTPTransport.quoteReplacement(msgId));
            MessageUtility.setText((String)txt2, (String)defaultMimeCS, (Part)ack);
            ack.setHeader("MIME-Version", "1.0");
            ack.setHeader("Content-Type", MimeMessageUtility.foldContentType((String)ct.toString()));
            ack.setHeader("Content-Disposition", CD_READ_ACK);
            mixedMultipart.addBodyPart((BodyPart)ack);
            MessageUtility.setContent((Multipart)mixedMultipart, (Part)smtpMessage);
            long start = System.currentTimeMillis();
            Transport transport = this.getSMTPSession().getTransport(SMTP);
            try {
                this.connectTransport(transport, smtpConfig);
                this.saveChangesSafe((MimeMessage)smtpMessage);
                this.transport((MimeMessage)smtpMessage, smtpMessage.getAllRecipients(), transport, smtpConfig);
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
            }
            catch (AuthenticationFailedException e) {
                throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
            }
            finally {
                transport.close();
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, smtpConfig, (Session)this.session);
        }
    }

    public MailMessage sendRawMessage(byte[] asciiBytes, Address[] allRecipients) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig0();
        try {
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession(), MimeHeaderNameChecker.sanitizeHeaderNames((byte[])asciiBytes));
            smtpMessage.removeHeader("x-original-headers");
            Address[] recipients = allRecipients == null ? smtpMessage.getAllRecipients() : allRecipients;
            SMTPTransport.checkRecipients(recipients);
            try {
                long start = System.currentTimeMillis();
                Transport transport = this.getSMTPSession().getTransport(SMTP);
                try {
                    this.connectTransport(transport, smtpConfig);
                    this.saveChangesSafe((MimeMessage)smtpMessage);
                    this.transport((MimeMessage)smtpMessage, recipients, transport, smtpConfig);
                    MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                }
                catch (AuthenticationFailedException e) {
                    throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
                }
                finally {
                    transport.close();
                }
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
            }
            MailMessage mailMessage = MimeMessageConverter.convertMessage((MimeMessage)smtpMessage);
            return mailMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMessage sendMailMessage(ComposedMailMessage composedMail, ComposeType sendType, Address[] allRecipients) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig0();
        try {
            MimeMessage mimeMessage = null;
            if (composedMail instanceof ContentAware) {
                try {
                    Object content = composedMail.getContent();
                    if (content instanceof MimeMessage) {
                        mimeMessage = (MimeMessage)content;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (null != mimeMessage) {
                MailPath msgref;
                mimeMessage.removeHeader("x-original-headers");
                if (ComposeType.REPLY.equals((Object)sendType) && (msgref = composedMail.getMsgref()) != null) {
                    MailAccess access = null;
                    try {
                        access = MailAccess.getInstance((Session)this.session, (int)msgref.getAccountId());
                        access.connect();
                        MimeMessageFiller.setReplyHeaders((MailMessage)access.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false), (MimeMessage)mimeMessage);
                    }
                    finally {
                        if (null != access) {
                            access.close(true);
                        }
                    }
                }
                SMTPMessageFiller smtpFiller = new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm);
                smtpFiller.setAccountId(this.accountId);
                smtpFiller.setCommonHeaders(mimeMessage);
                Address[] recipients = allRecipients == null ? mimeMessage.getAllRecipients() : allRecipients;
                SMTPTransport.checkRecipients(recipients);
                try {
                    long start = System.currentTimeMillis();
                    Transport transport = this.getSMTPSession().getTransport(SMTP);
                    try {
                        this.connectTransport(transport, smtpConfig);
                        this.saveChangesSafe(mimeMessage);
                        this.transport(mimeMessage, recipients, transport, smtpConfig);
                        MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                    }
                    catch (AuthenticationFailedException e) {
                        throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
                    }
                    finally {
                        transport.close();
                    }
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
                }
                return MimeMessageConverter.convertMessage((MimeMessage)mimeMessage);
            }
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
            long startPrep = System.currentTimeMillis();
            SMTPMessageFiller smtpFiller = new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm);
            smtpFiller.setAccountId(this.accountId);
            composedMail.setFiller((MimeMessageFiller)smtpFiller);
            try {
                smtpFiller.fillMail(composedMail, smtpMessage, sendType);
                Object[] recipients = allRecipients == null ? (composedMail.hasRecipients() ? composedMail.getRecipients() : smtpMessage.getAllRecipients()) : allRecipients;
                SMTPTransport.checkRecipients(recipients);
                smtpFiller.setSendHeaders(composedMail, (MimeMessage)smtpMessage);
                smtpMessage.removeHeader("x-original-headers");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuilder(128).append("SMTP mail prepared for transport in ").append(System.currentTimeMillis() - startPrep).append("msec").toString());
                }
                long start = System.currentTimeMillis();
                Transport transport = this.getSMTPSession().getTransport(SMTP);
                try {
                    this.connectTransport(transport, smtpConfig);
                    this.saveChangesSafe((MimeMessage)smtpMessage);
                    this.transport((MimeMessage)smtpMessage, (Address[])recipients, transport, smtpConfig);
                    MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                }
                catch (AuthenticationFailedException e) {
                    throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{smtpConfig.getServer(), e.getMessage()});
                }
                finally {
                    transport.close();
                }
            }
            finally {
                this.invokeLater(new MailCleanerTask(composedMail));
            }
            return MimeMessageConverter.convertMessage((MimeMessage)smtpMessage);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
        }
        catch (IOException e) {
            throw SMTPExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void connectTransport(Transport transport, SMTPConfig smtpConfig) throws OXException, MessagingException {
        String server = IDNA.toASCII((String)smtpConfig.getServer());
        int port = smtpConfig.getPort();
        if (smtpConfig.getSMTPProperties().isSmtpAuth()) {
            String encodedPassword = this.encodePassword(smtpConfig.getPassword());
            if (this.isKerberosAuth()) {
                try {
                    Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, smtpConfig.getLogin(), encodedPassword));
                }
                catch (PrivilegedActionException e) {
                    SMTPTransport.handlePrivilegedActionException(e);
                }
            } else {
                transport.connect(server, port, smtpConfig.getLogin(), encodedPassword);
            }
        } else {
            transport.connect(server, port, null, null);
        }
    }

    private void transport(MimeMessage smtpMessage, Address[] recipients, Transport transport, SMTPConfig smtpConfig) throws OXException {
        try {
            transport.sendMessage((Message)smtpMessage, recipients);
        }
        catch (MessagingException e) {
            String message;
            if (e.getNextException() instanceof UnsupportedDataTypeException && SMTPTransport.toLowerCase(message = e.getNextException().getMessage()).indexOf("no object dch") >= 0) {
                LOG.warn((Object)message.replaceFirst("[dD][cC][hH]", Matcher.quoteReplacement("javax.activation.DataContentHandler")));
                this.transportAlt(smtpMessage, recipients, transport, smtpConfig);
                return;
            }
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
        }
    }

    private void transportAlt(MimeMessage smtpMessage, Address[] recipients, Transport transport, SMTPConfig smtpConfig) throws OXException {
        try {
            final MimeMessageDataSource dataSource = new MimeMessageDataSource(smtpMessage, (MailConfig)smtpConfig, this.session);
            smtpMessage.setDataHandler(new DataHandler((DataSource)dataSource));
            if (!transport.isConnected()) {
                this.connectTransport(transport, smtpConfig);
            }
            transport.sendMessage((Message)smtpMessage, recipients);
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        dataSource.cleanUp();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (MessagingException me) {
            throw MimeMailException.handleMessagingException((MessagingException)me, (MailConfig)smtpConfig, (Session)this.session);
        }
    }

    private String encodePassword(String password) throws OXException {
        String tmpPass = password;
        if (tmpPass != null) {
            try {
                tmpPass = new String(password.getBytes(Charsets.forName((String)this.getTransportConfig0().getSMTPProperties().getSmtpAuthEnc())), Charsets.ISO_8859_1);
            }
            catch (UnsupportedCharsetException e) {
                LOG.error((Object)("Unsupported encoding in a message detected and monitored: \"" + e.getMessage() + '\"'), (Throwable)e);
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            }
        }
        return tmpPass;
    }

    protected void shutdown() {
        SMTPSessionProperties.resetDefaultSessionProperties();
        SMTPCapabilityCache.tearDown();
    }

    protected void startup() {
        SMTPCapabilityCache.init();
    }

    private static void checkRecipients(Address[] recipients) throws OXException {
        Filter filter;
        if (recipients == null || recipients.length == 0) {
            throw SMTPExceptionCode.MISSING_RECIPIENTS.create();
        }
        ConfigurationService service = (ConfigurationService)SMTPServiceRegistry.getServiceRegistry().getService(ConfigurationService.class);
        if (null != service && null != (filter = service.getFilterFromProperty("com.openexchange.mail.transport.redirectWhitelist"))) {
            for (Address address : recipients) {
                InternetAddress internetAddress = (InternetAddress)address;
                if (filter.accepts(internetAddress.getAddress())) continue;
                throw SMTPExceptionCode.RECIPIENT_NOT_ALLOWED.create(internetAddress.toUnicodeString());
            }
        }
    }

    public void ping() throws OXException {
        Transport transport;
        try {
            transport = this.getSMTPSession().getTransport(SMTP);
        }
        catch (NoSuchProviderException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        boolean close = false;
        SMTPConfig config = this.getTransportConfig0();
        try {
            try {
                this.connectTransport(transport, config);
                close = true;
            }
            catch (AuthenticationFailedException e) {
                throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{config.getServer(), e.getMessage()});
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)config, (Session)this.session);
        }
        finally {
            if (close) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    LOG.error((Object)"Closing SMTP transport failed.", (Throwable)e);
                }
            }
        }
    }

    protected ITransportProperties createNewMailProperties() throws OXException {
        MailAccountStorageService storageService = (MailAccountStorageService)SMTPServiceRegistry.getServiceRegistry().getService(MailAccountStorageService.class, true);
        return new MailAccountSMTPProperties(storageService.getMailAccount(this.accountId, this.session.getUserId(), this.session.getContextId()));
    }

    private void saveChangesSafe(MimeMessage mimeMessage) throws OXException {
        HostnameService hostnameService = (HostnameService)SMTPServiceRegistry.getServiceRegistry().getService(HostnameService.class);
        String hostName = null == hostnameService ? SMTPTransport.getHostName() : hostnameService.getHostname(this.session.getUserId(), this.session.getContextId());
        if (null == hostName) {
            hostName = SMTPTransport.getHostName();
        }
        MimeMessageConverter.saveChanges((MimeMessage)mimeMessage, (String)hostName);
    }

    private static String getHostName() {
        Props logProperties = LogProperties.optLogProperties();
        if (null == logProperties) {
            return SMTPTransport.getStaticHostName();
        }
        String serverName = (String)logProperties.get(LogProperties.Name.AJP_SERVER_NAME);
        if (null == serverName) {
            return SMTPTransport.getStaticHostName();
        }
        return serverName;
    }

    private static String getStaticHostName() {
        UnknownHostException warning = warnSpam;
        if (warning != null) {
            LOG.error((Object)"Can't resolve my own hostname, using 'localhost' instead, which is certainly not what you want!", (Throwable)warning);
        }
        return staticHostName;
    }

    private static String quoteReplacement(String str) {
        return SMTPTransport.isEmpty(str) ? "" : SMTPTransport.quoteReplacement0(str);
    }

    private static String quoteReplacement0(String s) {
        if (s.indexOf(92) < 0 && s.indexOf(36) < 0) {
            return s;
        }
        int length = s.length();
        StringAllocator sb = new StringAllocator(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    static {
        try {
            staticHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            staticHostName = "localhost";
            warnSpam = e;
        }
    }

    private static final class MailCleanerTask
    implements Runnable {
        private final ComposedMailMessage composedMail;

        public MailCleanerTask(ComposedMailMessage composedMail) {
            this.composedMail = composedMail;
        }

        @Override
        public void run() {
            this.composedMail.cleanUp();
        }
    }

    private static final class SaslSmtpLoginAction
    implements PrivilegedExceptionAction<Object> {
        private final Transport transport;
        private final String server;
        private final int port;
        private final String login;
        private final String pw;

        protected SaslSmtpLoginAction(Transport transport, String server, int port, String login, String pw) {
            this.transport = transport;
            this.server = server;
            this.port = port;
            this.login = login;
            this.pw = pw;
        }

        @Override
        public Object run() throws MessagingException {
            this.transport.connect(this.server, this.port, this.login, this.pw);
            return null;
        }
    }
}

