/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.impl;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.impl.DummyCollection;
import com.openexchange.webdav.protocol.impl.DummyResource;
import com.openexchange.webdav.protocol.impl.DummyResourceManager;
import java.util.HashMap;

public class DummyLockNull
extends DummyCollection {
    private static final Protocol.WEBDAV_METHOD[] OPTIONS = new Protocol.WEBDAV_METHOD[]{Protocol.WEBDAV_METHOD.PUT, Protocol.WEBDAV_METHOD.MKCOL, Protocol.WEBDAV_METHOD.OPTIONS, Protocol.WEBDAV_METHOD.PROPFIND, Protocol.WEBDAV_METHOD.LOCK, Protocol.WEBDAV_METHOD.UNLOCK, Protocol.WEBDAV_METHOD.TRACE};
    private WebdavResource realResource;

    public DummyLockNull(DummyResourceManager manager, WebdavPath url) {
        super(manager, url);
    }

    public void setRealResource(WebdavResource res) {
        this.realResource = res;
    }

    @Override
    public boolean isLockNull() {
        return true;
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        switch (p.getId()) {
            case 2: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void unlock(String token) throws WebdavProtocolException {
        super.unlock(token);
        if (this.getOwnLocks().isEmpty()) {
            this.mgr.removeLockNull(this.getUrl());
        }
    }

    @Override
    public Protocol.WEBDAV_METHOD[] getOptions() {
        return OPTIONS;
    }

    @Override
    public void delete() throws WebdavProtocolException {
        super.delete();
    }

    @Override
    public void create() throws WebdavProtocolException {
        WebdavResource res = this.getRealResource();
        try {
            res.create();
        }
        catch (OXException e) {
            throw new WebdavProtocolException(this.getUrl(), 500, e);
        }
        if (res instanceof DummyResource) {
            DummyResource dres = (DummyResource)res;
            dres.locks = new HashMap<String, WebdavLock>(this.locks);
        }
    }

    private WebdavResource getRealResource() {
        return this.realResource;
    }
}

