/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2426;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.text.DecimalFormat;

public class UTCOffsetValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new UTCOffsetValueDefinition();
    private static final DecimalFormat Format = new DecimalFormat("00");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        int sign = 1;
        switch (s.peek) {
            case 45: {
                sign = -1;
            }
            case 43: {
                break;
            }
            default: {
                throw new VersitException(s, "UTC offset expected");
            }
        }
        int offset = s.parseNumber(2) * 3600000;
        if (s.peek != 58) {
            throw new VersitException(s, "UTC offset expected");
        }
        s.read();
        return sign * (offset += s.parseNumber(2) * 60000);
    }

    @Override
    public String writeValue(Object value) {
        int offset = (Integer)value;
        return (offset >= 0 ? (char)'+' : '-') + Format.format(offset / 3600000) + ':' + Format.format(offset / 60000 % 60);
    }
}

