/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.Encoding;
import com.openexchange.tools.versit.FoldingWriter;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ValueDefinition {
    private final Map<String, Encoding> Encodings;
    private static final Map<String, Encoding> NoEncodings = new HashMap<String, Encoding>();

    public ValueDefinition() {
        this.Encodings = NoEncodings;
    }

    public ValueDefinition(String[] encodingNames, Encoding[] encodings) {
        this.Encodings = new HashMap<String, Encoding>();
        for (int i = 0; i < encodingNames.length; ++i) {
            this.Encodings.put(encodingNames[i].toUpperCase(Locale.ENGLISH), encodings[i]);
        }
    }

    public Encoding getEncoding(String name) {
        return this.Encodings.get(name.toUpperCase(Locale.ENGLISH));
    }

    public Object parse(Scanner s, Property property) throws IOException {
        StringBuilder sb = new StringBuilder();
        while ((s.peek >= 32 || s.peek == 9) && s.peek != 127) {
            sb.append((char)s.read());
        }
        String text = sb.toString();
        Parameter encodingParam = property.getParameter("ENCODING");
        if (encodingParam != null) {
            String EncName = encodingParam.getValue(0).getText();
            Encoding encoding = this.getEncoding(EncName);
            if (encoding == null) {
                throw new VersitException(s, "Unknown encoding: " + EncName);
            }
            text = encoding.decode(text);
        }
        return this.createValue(new StringScanner(s, text), property);
    }

    public Object createValue(StringScanner s, Property property) throws IOException {
        return s.getRest();
    }

    public void write(FoldingWriter fw, Property property) throws IOException {
        String value = this.writeValue(property.getValue());
        Parameter encodingParam = property.getParameter("ENCODING");
        if (encodingParam != null) {
            String enc_name = encodingParam.getValue(0).getText();
            Encoding encoding = this.getEncoding(enc_name);
            if (encoding == null) {
                throw new IOException("Unknown encoding: " + enc_name);
            }
            value = encoding.encode(value);
        }
        fw.writeln(value);
    }

    public String writeValue(Object value) {
        return value.toString();
    }
}

