/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.downgrade.sql;

import com.openexchange.tools.Collections;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class OXFolderDowngradeSQL {
    private static final String RPL_PERM = "#PERM#";
    private static final String RPL_FOLDER = "#FOLDER#";
    private static final String SQL_DROP_MODULE_SYS_PERMS = "DELETE op FROM #PERM# AS op JOIN #FOLDER# AS ot ON op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? WHERE ot.module = ? AND ot.type = ? AND op.permission_id = ? AND op.system > 0";
    private static final String SQL_SEL_MOD_PRIV_FLD = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.type = ? AND ot.created_from = ? AND ot.module = ? AND ot.default_flag = 0 GROUP BY ot.fuid";
    private static final String SQL_DEL_FLD_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ?";
    private static final String SQL_DEL_FLDS = "DELETE FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.fuid = ?";
    private static final String SQL_SEL_PUBLIC_FLDS_ALL = "SELECT op.fuid FROM #PERM# AS op JOIN #FOLDER# AS ot ON op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? WHERE ot.module = ? AND op.permission_id = ? AND ot.type = ? GROUP BY op.fuid";
    private static final String SQL_SEL_PUBLIC_FLDS_WO_DEFAULT = "SELECT op.fuid FROM #PERM# AS op JOIN #FOLDER# AS ot ON op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? WHERE ot.module = ? AND op.permission_id = ? AND ot.type = ? AND ot.default_flag = 0 GROUP BY op.fuid";
    private static final String SQL_SEL_DEF_FLD = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.module = ? AND ot.created_from = ? AND ot.default_flag = 1";
    private static final String SQL_DEL_DEF_FLD_PERM = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ? AND permission_id <> ?";
    private static final String SQL_LOAD_PERMS = "SELECT op.permission_id, op.fp, op.orp, op.owp, op.odp, op.admin_flag, op.group_flag FROM #PERM# AS op WHERE op.cid = ? AND op.fuid = ?";
    private static final String SQL_REASSIGN_UPDATE_PERM = "UPDATE #PERM# SET fp = ?, orp = ?, owp = ?, odp = ?, admin_flag = ?, group_flag = ?, permission_id = ? WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_DELETE_PERM = "DELETE FROM #PERM# WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_SELECT_ADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_SEL_SHARED_PERMS = "SELECT ot.fuid FROM #FOLDER# AS ot JOIN #PERM# AS op USING(cid,fuid) WHERE ot.cid = ? AND ot.created_from = ? AND ot.type = ? AND op.permission_id <> ?";
    private static final String SQL_SEL_SHARED_PERMS_FOREIGN = "SELECT ot.fuid FROM #FOLDER# AS ot JOIN #PERM# AS op USING (cid,fuid) WHERE ot.cid = ? AND ot.created_from <> ? AND ot.type = ? AND op.permission_id = ?";
    private static final String SQL_DEL_SHARED_PERMS = "DELETE op FROM #PERM# AS op, #FOLDER# AS ot WHERE op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? AND ot.created_from = ? AND ot.type = ? AND op.permission_id <> ?";
    private static final String SQL_DEL_SHARED_PERMS_FOREIGN = "DELETE op FROM #PERM# AS op, #FOLDER# AS ot WHERE op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? AND ot.created_from <> ? AND ot.type = ? AND op.permission_id = ?";
    private static final String SQL_SEL_SUB_INFO_FLD = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.module = ? AND ot.parent IN (SELECT ot2.fuid FROM #FOLDER# AS ot2 WHERE ot2.cid = ? AND ot2.module = ? AND ot2.created_from = ? AND ot2.default_flag = 1)";
    private static final String SQL_SEL_SUB2_INFO_FLD = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.parent = ?";

    private OXFolderDowngradeSQL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropModuleSystemPermission(int module, int entity, int cid, String folderTable, String permTable, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DROP_MODULE_SYS_PERMS.replaceFirst(RPL_PERM, permTable).replaceFirst(RPL_FOLDER, folderTable));
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, module);
            stmt.setInt(pos++, 2);
            stmt.setInt(pos++, entity);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getModulePrivateFolders(int module, int owner, int cid, String folderTable, Connection readCon) throws SQLException {
        int[] nArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(SQL_SEL_MOD_PRIV_FLD.replaceFirst(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, 1);
            stmt.setInt(3, owner);
            stmt.setInt(4, module);
            rs = stmt.executeQuery();
            Collections.SmartIntArray sia = new Collections.SmartIntArray(128);
            while (rs.next()) {
                sia.append(rs.getInt(1));
            }
            nArray = sia.toArray();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFolderPermissions(int[] fuids, int cid, String permTable, Connection writeCon) throws SQLException {
        if (0 == fuids.length) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DEL_FLD_PERMS.replaceFirst(RPL_PERM, permTable));
            for (int fuid : fuids) {
                stmt.setInt(1, cid);
                stmt.setInt(2, fuid);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFolders(int[] fuids, int cid, String folderTable, Connection writeCon) throws SQLException {
        if (0 == fuids.length) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DEL_FLDS.replaceFirst(RPL_FOLDER, folderTable));
            for (int fuid : fuids) {
                stmt.setInt(1, cid);
                stmt.setInt(2, fuid);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getAffectedPublicFolders(int entity, int module, int cid, String folderTable, String permTable, Connection readCon, boolean all) throws SQLException {
        int[] nArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement((all ? SQL_SEL_PUBLIC_FLDS_ALL : SQL_SEL_PUBLIC_FLDS_WO_DEFAULT).replaceFirst(RPL_PERM, permTable).replaceFirst(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, cid);
            stmt.setInt(3, module);
            stmt.setInt(4, entity);
            stmt.setInt(5, 2);
            rs = stmt.executeQuery();
            Collections.SmartIntArray sia = new Collections.SmartIntArray(128);
            while (rs.next()) {
                sia.append(rs.getInt(1));
            }
            nArray = sia.toArray();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cleanDefaultModuleFolder(int entity, int module, int cid, String folderTable, String permTable, Connection writeCon) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            int n;
            stmt = null;
            rs = null;
            try {
                stmt = writeCon.prepareStatement(SQL_SEL_DEF_FLD.replaceFirst(RPL_FOLDER, folderTable));
                stmt.setInt(1, cid);
                stmt.setInt(2, module);
                stmt.setInt(3, entity);
                rs = stmt.executeQuery();
                if (rs.next()) break block6;
                n = -1;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            return n;
        }
        int fuid = rs.getInt(1);
        DBUtils.closeSQLStuff(rs, stmt);
        rs = null;
        stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_DEL_DEF_FLD_PERM.replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, fuid);
            stmt.setInt(3, entity);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
        return fuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleAffectedPublicFolder(int entity, int fuid, int cid, String permTable, Connection writeCon) throws SQLException {
        ArrayList<Permission> perms;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement(SQL_LOAD_PERMS.replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, fuid);
            rs = stmt.executeQuery();
            perms = new ArrayList<Permission>();
            while (rs.next()) {
                perms.add(new Permission(rs.getInt(1), fuid, rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6) > 0, rs.getInt(7) > 0));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            rs = null;
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        stmt = null;
        rs = null;
        int mailAdmin = OXFolderDowngradeSQL.getContextAdminID(cid, writeCon);
        if (perms.size() == 1) {
            OXFolderDowngradeSQL.updateSingleEntityPermission((Permission)perms.get(0), mailAdmin, permTable, writeCon, cid);
        } else {
            Permission onlyPerm = OXFolderDowngradeSQL.isOnlyAdmin(perms, entity);
            if (null != onlyPerm) {
                Permission adminPerm = OXFolderDowngradeSQL.getEntityPerm(perms, mailAdmin);
                if (null == adminPerm) {
                    OXFolderDowngradeSQL.updateSingleEntityPermission(onlyPerm, mailAdmin, permTable, writeCon, cid);
                } else {
                    OXFolderDowngradeSQL.updateSingleEntityPermission(OXFolderDowngradeSQL.mergePermission(adminPerm, onlyPerm), mailAdmin, permTable, writeCon, cid);
                }
            } else {
                Permission entityPerm = OXFolderDowngradeSQL.getEntityPerm(perms, entity);
                OXFolderDowngradeSQL.deleteSingleEntityPermission(entityPerm, permTable, writeCon, cid);
            }
        }
    }

    private static Permission isOnlyAdmin(List<Permission> perms, int entity) {
        int size = perms.size();
        int count = 0;
        int adminIndex = -1;
        for (int i = 0; i < size && count < 2; ++i) {
            Permission permission = perms.get(i);
            if (!permission.admin) continue;
            ++count;
            adminIndex = permission.entity == entity ? i : -1;
        }
        return count == 1 && adminIndex != -1 ? perms.get(adminIndex) : null;
    }

    private static Permission getEntityPerm(List<Permission> perms, int entity) {
        for (Permission permission : perms) {
            if (permission.entity != entity) continue;
            return permission;
        }
        return null;
    }

    private static Permission mergePermission(Permission adminPerm, Permission entityPerm) {
        return new Permission(entityPerm.entity, entityPerm.fuid, entityPerm.group, adminPerm, entityPerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSingleEntityPermission(Permission permission, int mailAdmin, String permTable, Connection wc, int cid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = wc.prepareStatement(SQL_REASSIGN_UPDATE_PERM.replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, permission.fp);
            stmt.setInt(2, permission.orp);
            stmt.setInt(3, permission.owp);
            stmt.setInt(4, permission.odp);
            stmt.setInt(5, permission.admin ? 1 : 0);
            stmt.setInt(6, permission.group ? 1 : 0);
            stmt.setInt(7, mailAdmin);
            stmt.setInt(8, cid);
            stmt.setInt(9, permission.entity);
            stmt.setInt(10, permission.fuid);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSingleEntityPermission(Permission permission, String permTable, Connection wc, int cid) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = wc.prepareStatement(SQL_DELETE_PERM.replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, permission.entity);
            stmt.setInt(3, permission.fuid);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getContextAdminID(int cid, Connection readCon) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            int n;
            stmt = null;
            rs = null;
            try {
                stmt = readCon.prepareStatement(SQL_SELECT_ADMIN);
                stmt.setInt(1, cid);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                n = -1;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return n;
        }
        int n = rs.getInt(1);
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> removeShareAccess(int entity, int cid, String folderTable, String permTable, Connection writeCon) throws SQLException {
        HashSet<Integer> ids = new HashSet<Integer>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement(SQL_SEL_SHARED_PERMS.replaceFirst(RPL_FOLDER, folderTable).replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, entity);
            stmt.setInt(3, 1);
            stmt.setInt(4, entity);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = writeCon.prepareStatement(SQL_DEL_SHARED_PERMS.replaceAll(RPL_PERM, permTable).replaceFirst(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, cid);
            stmt.setInt(3, entity);
            stmt.setInt(4, 1);
            stmt.setInt(5, entity);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_SEL_SHARED_PERMS_FOREIGN.replaceFirst(RPL_FOLDER, folderTable).replaceFirst(RPL_PERM, permTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, entity);
            stmt.setInt(3, 1);
            stmt.setInt(4, entity);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getInt(1));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = writeCon.prepareStatement(SQL_DEL_SHARED_PERMS_FOREIGN.replaceAll(RPL_PERM, permTable).replaceFirst(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, cid);
            stmt.setInt(3, entity);
            stmt.setInt(4, 1);
            stmt.setInt(5, entity);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
        }
        return Collections.unmodifiableSet(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] gatherSubInfostoreFolders(int entity, int cid, String folderTable, String permTable, Connection writeCon) throws SQLException {
        int[] fuids;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement(SQL_SEL_SUB_INFO_FLD.replaceAll(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, 8);
            stmt.setInt(3, cid);
            stmt.setInt(4, 8);
            stmt.setInt(5, entity);
            rs = stmt.executeQuery();
            Collections.SmartIntArray sia = new Collections.SmartIntArray(128);
            while (rs.next()) {
                sia.append(rs.getInt(1));
            }
            fuids = sia.toArray();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        rs = null;
        stmt = null;
        HashSet<Integer> ids = new HashSet<Integer>(64);
        for (int fuid : fuids) {
            OXFolderDowngradeSQL.gatherSubfolderIDs(fuid, cid, folderTable, permTable, ids, writeCon);
        }
        int[] retval = new int[ids.size()];
        if (retval.length > 0) {
            Iterator iter = ids.iterator();
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = (Integer)iter.next();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gatherSubfolderIDs(int fuid, int cid, String folderTable, String permTable, Set<Integer> ids, Connection writeCon) throws SQLException {
        int[] subFuids;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement(SQL_SEL_SUB2_INFO_FLD.replaceFirst(RPL_FOLDER, folderTable));
            stmt.setInt(1, cid);
            stmt.setInt(2, fuid);
            rs = stmt.executeQuery();
            Collections.SmartIntArray sia = new Collections.SmartIntArray(128);
            while (rs.next()) {
                sia.append(rs.getInt(1));
            }
            subFuids = sia.toArray();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = null;
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        stmt = null;
        for (int subFuid : subFuids) {
            OXFolderDowngradeSQL.gatherSubfolderIDs(subFuid, cid, folderTable, permTable, ids, writeCon);
        }
        ids.add(fuid);
    }

    private static final class Permission {
        public final int entity;
        public final int fuid;
        public final int fp;
        public final int orp;
        public final int owp;
        public final int odp;
        public final boolean admin;
        public final boolean group;

        public Permission(int entity, int fuid, int fp, int orp, int owp, int odp, boolean admin, boolean group) {
            this.entity = entity;
            this.fuid = fuid;
            this.admin = admin;
            this.group = group;
            this.fp = fp;
            this.odp = odp;
            this.orp = orp;
            this.owp = owp;
        }

        public Permission(int entity, Permission src) {
            this.entity = entity;
            this.fuid = src.fuid;
            this.admin = src.admin;
            this.group = src.group;
            this.fp = src.fp;
            this.odp = src.odp;
            this.orp = src.orp;
            this.owp = src.owp;
        }

        public Permission(int entity, int fuid, boolean group, Permission src1, Permission src2) {
            this.entity = entity;
            this.fuid = fuid;
            this.admin = src1.admin || src2.admin;
            this.group = group;
            this.fp = Math.max(src1.fp, src2.fp);
            this.odp = Math.max(src1.odp, src2.odp);
            this.orp = Math.max(src1.orp, src2.orp);
            this.owp = Math.max(src1.owp, src2.owp);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("Entity=").append(this.entity).append(", Folder=").append(this.fuid).append('\n');
            sb.append("fp=").append(this.fp).append(", orp=").append(this.orp).append(", owp=").append(this.owp).append(", odp=").append(this.odp).append(", admin=").append(this.admin).append(", group=").append(this.group).append('\n');
            return sb.toString();
        }
    }
}

