/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.osgi;

import com.openexchange.database.DatabaseService;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import com.openexchange.tools.file.internal.DBQuotaFileStorageFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DBQuotaFileStorageRegisterer
implements ServiceTrackerCustomizer<Object, Object> {
    private ServiceRegistration<QuotaFileStorageFactory> registration = null;
    private final BundleContext context;
    private final Lock lock = new ReentrantLock();
    private DatabaseService dbService;
    private FileStorageFactory fssService;
    boolean isRegistered = false;

    public DBQuotaFileStorageRegisterer(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        Object service = this.context.getService(reference);
        boolean needsRegistration = false;
        this.lock.lock();
        try {
            if (service instanceof DatabaseService) {
                this.dbService = (DatabaseService)service;
            }
            if (service instanceof FileStorageFactory) {
                this.fssService = (FileStorageFactory)service;
            }
            if (this.dbService != null && this.fssService != null && !this.isRegistered) {
                needsRegistration = true;
                this.isRegistered = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (needsRegistration) {
            DBQuotaFileStorageFactory qfss = new DBQuotaFileStorageFactory(this.dbService, this.fssService);
            this.registration = this.context.registerService(QuotaFileStorageFactory.class, (Object)qfss, null);
        }
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        boolean needsUnregistration = false;
        ServiceRegistration<QuotaFileStorageFactory> reg = this.registration;
        if (service instanceof DatabaseService) {
            this.dbService = null;
        }
        if (service instanceof FileStorageFactory) {
            this.fssService = null;
        }
        this.lock.lock();
        try {
            if ((this.dbService == null || this.fssService == null) && this.isRegistered) {
                this.registration = null;
                needsUnregistration = true;
                this.isRegistered = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (needsUnregistration) {
            reg.unregister();
        }
    }
}

