/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.search.internal;

import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.Operation;
import com.openexchange.search.SearchAttributeFetcher;
import com.openexchange.search.SearchService;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class SearchServiceImpl
implements SearchService {
    private static final Map<SingleSearchTerm.SingleOperation, SingleTermMatcher> MATCHERS;

    private static <C> boolean singleTermMatch(C candidate, SingleSearchTerm searchTerm, SearchAttributeFetcher<C> attributeFetcher) {
        SingleTermMatcher stm = MATCHERS.get(searchTerm.getOperation());
        if (null == stm) {
            return false;
        }
        return stm.matches(searchTerm.getOperands(), candidate, attributeFetcher);
    }

    @Override
    public <C> boolean matches(C candidate, SearchTerm<?> searchTerm, SearchAttributeFetcher<C> attributeFetcher) {
        Operation operation = searchTerm.getOperation();
        if (CompositeSearchTerm.CompositeOperation.AND.equals(operation)) {
            SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            if (searchTerms.length == 0) {
                return true;
            }
            boolean matches = this.matches(candidate, searchTerms[0], attributeFetcher);
            for (int i = 1; i < searchTerms.length && matches; matches &= this.matches(candidate, searchTerms[1], attributeFetcher), ++i) {
            }
            return matches;
        }
        if (CompositeSearchTerm.CompositeOperation.OR.equals(operation)) {
            SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            if (searchTerms.length == 0) {
                return true;
            }
            boolean matches = this.matches(candidate, searchTerms[0], attributeFetcher);
            for (int i = 1; i < searchTerms.length && !matches; matches |= this.matches(candidate, searchTerms[1], attributeFetcher), ++i) {
            }
            return matches;
        }
        if (CompositeSearchTerm.CompositeOperation.NOT.equals(operation)) {
            SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            if (searchTerms.length == 0) {
                return true;
            }
            return !this.matches(candidate, searchTerms[0], attributeFetcher);
        }
        return SearchServiceImpl.singleTermMatch(candidate, (SingleSearchTerm)searchTerm, attributeFetcher);
    }

    @Override
    public <C> Collection<C> filter(Collection<C> candidates, SearchTerm<?> searchTerm, SearchAttributeFetcher<C> attributeFetcher) {
        ArrayList<C> retval = new ArrayList<C>(candidates.size());
        for (C candidate : candidates) {
            if (!this.matches(candidate, searchTerm, attributeFetcher)) continue;
            retval.add(candidate);
        }
        return retval;
    }

    static {
        EnumMap<SingleSearchTerm.SingleOperation, SingleTermMatcher> m = new EnumMap<SingleSearchTerm.SingleOperation, SingleTermMatcher>(SingleSearchTerm.SingleOperation.class);
        m.put(SingleSearchTerm.SingleOperation.EQUALS, new SingleTermMatcher(){

            @Override
            public <C> boolean matches(Operand<?>[] operands, C candidate, SearchAttributeFetcher<C> attributeFetcher) {
                Object value1 = 1.getValue(operands[0], candidate, attributeFetcher);
                Object value2 = 1.getValue(operands[1], candidate, attributeFetcher);
                if (null == value1) {
                    return null == value2;
                }
                return value1.equals(value2);
            }
        });
        m.put(SingleSearchTerm.SingleOperation.GREATER_THAN, new SingleTermMatcher(){

            @Override
            public <C> boolean matches(Operand<?>[] operands, C candidate, SearchAttributeFetcher<C> attributeFetcher) {
                Object value1 = 2.getValue(operands[0], candidate, attributeFetcher);
                Object value2 = 2.getValue(operands[1], candidate, attributeFetcher);
                if (null == value1 || null == value2) {
                    return false;
                }
                if (value1 instanceof Comparable && value2 instanceof Comparable) {
                    return ((Comparable)value1).compareTo(value2) > 0;
                }
                return false;
            }
        });
        m.put(SingleSearchTerm.SingleOperation.LESS_THAN, new SingleTermMatcher(){

            @Override
            public <C> boolean matches(Operand<?>[] operands, C candidate, SearchAttributeFetcher<C> attributeFetcher) {
                Object value1 = 3.getValue(operands[0], candidate, attributeFetcher);
                Object value2 = 3.getValue(operands[1], candidate, attributeFetcher);
                if (null == value1 || null == value2) {
                    return false;
                }
                if (value1 instanceof Comparable && value2 instanceof Comparable) {
                    return ((Comparable)value1).compareTo(value2) < 0;
                }
                return false;
            }
        });
        MATCHERS = Collections.unmodifiableMap(m);
    }

    private static abstract class SingleTermMatcher {
        public abstract <C> boolean matches(Operand<?>[] var1, C var2, SearchAttributeFetcher<C> var3);

        public static <C> Object getValue(Operand<?> operand, C candidate, SearchAttributeFetcher<C> attributeFetcher) {
            if (Operand.Type.CONSTANT.equals((Object)operand.getType())) {
                return operand.getValue();
            }
            return attributeFetcher.getAttribute(operand.getValue().toString(), candidate);
        }
    }
}

