/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.report.internal.LoginCounterMBean;
import com.openexchange.report.internal.ReportingMBean;
import com.openexchange.report.internal.Tools;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import org.apache.commons.logging.Log;

public class LoginCounter
implements LoginCounterMBean {
    private final Log logger = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReportingMBean.class));

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Object[]> getLastLoginTimeStamp(int userId, int contextId, String client) throws MBeanException {
        List<Object[]> ret222222;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        DatabaseService service;
        block12: {
            service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (null == service) {
                throw new MBeanException(null, "DatabaseService not available at the moment. Try again later.");
            }
            con = null;
            stmt = null;
            rs = null;
            con = service.getReadOnly(contextId);
            if (!"*".equals(client.trim())) break block12;
            stmt = con.prepareStatement("SELECT value, name FROM user_attribute WHERE cid=? AND id=? AND name LIKE 'client:%'");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            LinkedList<Object[]> ret222222 = new LinkedList<Object[]>();
            while (rs.next()) {
                String name = rs.getString(2);
                ret222222.add(new Object[]{new Date(Long.parseLong(rs.getString(1))), name.substring(7)});
            }
            LinkedList<Object[]> linkedList = ret222222;
            LoginCounter.closeSQLStuff(rs, stmt);
            if (null != con) {
                service.backReadOnly(contextId, con);
            }
            return linkedList;
        }
        try {
            stmt = con.prepareStatement("SELECT value FROM user_attribute WHERE cid=? AND id=? AND name=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setString(3, "client:" + client);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new MBeanException(null, "No such entry found (user=" + userId + ", context=" + contextId + ", client=\"" + client + "\").");
            }
            ret222222 = Collections.singletonList(new Object[]{new Date(Long.parseLong(rs.getString(1))), client});
        }
        catch (MBeanException e) {
            try {
                throw e;
                catch (Exception e2) {
                    this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new MBeanException(null, "Retrieving last login time stamp failed: " + e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                LoginCounter.closeSQLStuff(rs, stmt);
                if (null != con) {
                    service.backReadOnly(contextId, con);
                }
                throw throwable;
            }
        }
        LoginCounter.closeSQLStuff(rs, stmt);
        if (null != con) {
            service.backReadOnly(contextId, con);
        }
        return ret222222;
    }

    @Override
    public Map<String, Integer> getNumberOfLogins(Date startDate, Date endDate, boolean aggregate, String regex) throws MBeanException {
        if (startDate == null) {
            throw new MBeanException(new IllegalArgumentException("Parameter 'startDate' must not be null!"));
        }
        if (endDate == null) {
            throw new MBeanException(new IllegalArgumentException("Parameter 'endDate' must not be null!"));
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Map<String, Integer> schemaMap = null;
        try {
            schemaMap = Tools.getAllSchemata(this.logger);
        }
        catch (OXException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        int sum = 0;
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String schema : schemaMap.keySet()) {
            Connection connection;
            HashSet<UserContextId> countedUsers = new HashSet<UserContextId>();
            int readPool = schemaMap.get(schema);
            try {
                connection = dbService.get(readPool, schema);
            }
            catch (OXException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new MBeanException((Exception)((Object)e), "Couldn't get connection to schema " + schema + " in pool " + readPool + ".");
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                StringBuilder sb = new StringBuilder("SELECT cid, id, name, value FROM user_attribute WHERE name REGEXP ?");
                if (regex == null) {
                    regex = ".*";
                }
                stmt = connection.prepareStatement(sb.toString());
                stmt.setString(1, "client:(" + regex + ")");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int contextId = rs.getInt(1);
                    int userId = rs.getInt(2);
                    String client = rs.getString(3);
                    try {
                        Date lastLogin = new Date(Long.parseLong(rs.getString(4)));
                        if (!lastLogin.after(startDate) || !lastLogin.before(endDate)) continue;
                        if (aggregate) {
                            UserContextId userContextId = new UserContextId(contextId, userId);
                            if (!countedUsers.contains(userContextId)) {
                                countedUsers.add(userContextId);
                                ++sum;
                            }
                        } else {
                            ++sum;
                        }
                        Integer value = (Integer)results.get(client);
                        if (value == null) {
                            results.put(client, 1);
                            continue;
                        }
                        results.put(client, value + 1);
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn((Object)"Client value is not a number.", (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new MBeanException(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    dbService.back(readPool, connection);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            dbService.back(readPool, connection);
        }
        results.put("sum", sum);
        return results;
    }

    private static void closeSQLStuff(ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void closeSQLStuff(Statement stmt) {
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void closeSQLStuff(ResultSet result, Statement stmt) {
        LoginCounter.closeSQLStuff(result);
        LoginCounter.closeSQLStuff(stmt);
    }

    private static final class UserContextId {
        private final int contextId;
        private final int userId;
        private final int hash;

        public UserContextId(int contextId, int userId) {
            this.contextId = contextId;
            this.userId = userId;
            int prime = 31;
            int result = 1;
            result = 31 * result + contextId;
            this.hash = result = 31 * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserContextId other = (UserContextId)obj;
            if (this.contextId != other.contextId) {
                return false;
            }
            return this.userId == other.userId;
        }
    }
}

