/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser;

import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.TNEFBodyPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailPart;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.tnef.TNEF2ICal;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.CompressedRTFInputStream;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.ContactHandler;
import net.freeutils.tnef.mime.RawDataSource;
import net.freeutils.tnef.mime.ReadReceiptHandler;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;
import org.apache.commons.logging.Log;

public final class MailMessageParser {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailMessageParser.class));
    private static final String APPL_OCTET = "application/octet-stream";
    private static final boolean WARN_ENABLED = LOG.isWarnEnabled();
    private static final String HDR_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String HDR_CONTENT_TYPE = "Content-Type";
    private static final int BUF_SIZE = 8192;
    private static final Iterator<Map.Entry<String, String>> EMPTY_ITER = new Iterator<Map.Entry<String, String>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, String> next() {
            throw new NoSuchElementException("Iterator is empty");
        }

        @Override
        public void remove() {
        }
    };
    private static final InlineDetector LENIENT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return "inline".equalsIgnoreCase(disposition) || disposition == null && fileName == null;
        }
    };
    private static final InlineDetector STRICT_DETECTOR = new InlineDetector(){

        @Override
        public boolean isInline(String disposition, String fileName) {
            return ("inline".equalsIgnoreCase(disposition) || disposition == null) && fileName == null;
        }
    };
    private static final String TNEF_IPM_CONTACT = "IPM.Contact";
    private static final String TNEF_IPM_MS_READ_RECEIPT = "IPM.Microsoft Mail.Read Receipt";
    private boolean stop;
    private boolean multipartDetected;
    private InlineDetector inlineDetector = LENIENT_DETECTOR;
    private String subject;
    private MimeFilter mimeFilter = null;
    private final List<OXException> warnings = new ArrayList<OXException>(2);
    private String mailId;
    private String folder;
    private static final String PREFIX = "Part_";
    private static final String HDR_CONTENT_TRANSFER_ENC = "Content-Transfer-Encoding";
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_TEXT = new String[]{"plain", "enriched", "richtext", "rtf"};
    private static final String PRIMARY_HTML = "text/htm";
    private static final String PRIMARY_MULTI = "multipart/";
    private static final String PRIMARY_IMAGE = "image/";
    private static final String PRIMARY_RFC822 = "message/rfc822";
    private static final String PRIMARY_MESSAGE = "message/";
    private static final String[] SUB_SPECIAL1 = new String[]{"delivery-status", "disposition-notification"};
    private static final String[] SUB_SPECIAL2 = new String[]{"rfc822-headers", "vcard", "x-vcard", "calendar", "x-vcalendar"};

    public MailMessageParser setInlineDetectorBehavior(boolean strict) {
        this.inlineDetector = strict ? STRICT_DETECTOR : LENIENT_DETECTOR;
        return this;
    }

    public MailMessageParser addMimeFilter(MimeFilter mimeFilter) {
        this.mimeFilter = mimeFilter;
        return this;
    }

    public List<OXException> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public MailMessageParser reset() {
        this.stop = false;
        this.multipartDetected = false;
        this.subject = null;
        return this;
    }

    public void parseMailMessage(MailMessage mail, MailMessageHandler handler) throws OXException {
        this.parseMailMessage(mail, handler, null);
    }

    public void parseMailMessage(MailMessage mail, MailMessageHandler handler, String prefix) throws OXException {
        if (null == mail) {
            throw MailExceptionCode.MISSING_PARAMETER.create("mail");
        }
        if (null == handler) {
            throw MailExceptionCode.MISSING_PARAMETER.create("handler");
        }
        boolean logPropsEnabled = LogProperties.isEnabled();
        try {
            if (logPropsEnabled) {
                String folder;
                String mailId;
                Props properties = LogProperties.getLogProperties();
                int accountId = mail.getAccountId();
                if (accountId >= 0) {
                    properties.put(LogProperties.Name.MAIL_ACCOUNT_ID, (Object)ForceLog.valueOf((Object)accountId));
                }
                if (null != (mailId = mail.getMailId())) {
                    properties.put(LogProperties.Name.MAIL_MAIL_ID, (Object)ForceLog.valueOf((Object)mailId));
                }
                if (null != (folder = mail.getFolder())) {
                    properties.put(LogProperties.Name.MAIL_FULL_NAME, (Object)ForceLog.valueOf((Object)folder));
                }
            }
            this.parseEnvelope(mail, handler);
            this.mailId = mail.getMailId();
            this.folder = mail.getFolder();
            this.parseMailContent(mail, handler, prefix, 1);
        }
        catch (IOException e) {
            String mailId = mail.getMailId();
            String folder = mail.getFolder();
            throw MailExceptionCode.UNREADBALE_PART_CONTENT.create(e, null == mailId ? "" : mailId, null == folder ? "" : folder);
        }
        finally {
            if (logPropsEnabled) {
                Props properties = LogProperties.getLogProperties();
                properties.remove(LogProperties.Name.MAIL_ACCOUNT_ID);
                properties.remove(LogProperties.Name.MAIL_MAIL_ID);
                properties.remove(LogProperties.Name.MAIL_FULL_NAME);
            }
        }
        handler.handleMessageEnd(mail);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMailContent(MailPart mailPartArg, MailMessageHandler handler, String prefix, int partCountArg) throws OXException, IOException {
        if (this.stop) {
            return;
        }
        MailPart mailPart = MailConfig.usePartModifier() ? MailConfig.getPartModifier().modifyPart(mailPartArg) : mailPartArg;
        int partCount = partCountArg;
        String disposition = mailPart.containsContentDisposition() ? mailPart.getContentDisposition().getDisposition() : null;
        long size = mailPart.getSize();
        ContentType contentType = mailPart.containsContentType() ? mailPart.getContentType() : new ContentType(APPL_OCTET);
        String lcct = LocaleTools.toLowerCase((CharSequence)contentType.getBaseType());
        if (null != this.mimeFilter && this.mimeFilter.ignorable(lcct, mailPart)) {
            return;
        }
        String fileName = MailMessageParser.getFileName(mailPart.getFileName(), MailMessageParser.getSequenceId(prefix, partCount), lcct);
        boolean isInline = this.inlineDetector.isInline(disposition, mailPart.getFileName());
        if (MailMessageParser.isMultipart(lcct)) {
            try {
                String mpPrefix;
                String mpId;
                int count = mailPart.getEnclosedCount();
                if (count == -1) {
                    throw MailExceptionCode.INVALID_MULTIPART_CONTENT.create();
                }
                String string = mpId = null == prefix && !this.multipartDetected ? "" : MailMessageParser.getSequenceId(prefix, partCount);
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(mpId);
                }
                if (!handler.handleMultipart(mailPart, count, mpId)) {
                    this.stop = true;
                    return;
                }
                if (this.multipartDetected) {
                    mpPrefix = mpId;
                } else {
                    mpPrefix = prefix;
                    this.multipartDetected = true;
                }
                for (int i = 0; i < count; ++i) {
                    MailPart enclosedContent = mailPart.getEnclosedMailPart(i);
                    this.parseMailContent(enclosedContent, handler, mpPrefix, i + 1);
                }
                if (handler.handleMultipartEnd(mailPart, mpId)) return;
                this.stop = true;
                return;
            }
            catch (RuntimeException rte) {
                LOG.error((Object)"Multipart mail could not be parsed", (Throwable)rte);
                this.warnings.add(MailExceptionCode.UNPARSEABLE_MESSAGE.create(rte, new Object[0]));
                if (handler.handleInlinePlainText("", ContentType.DEFAULT_CONTENT_TYPE, 0L, fileName, MailMessageParser.getSequenceId(prefix, partCount))) return;
                this.stop = true;
                return;
            }
        }
        if (MailMessageParser.isText(lcct)) {
            if (isInline) {
                String content = MailMessageParser.readContent(mailPart, contentType, this.mailId, this.folder);
                UUEncodedMultiPart uuencodedMP = new UUEncodedMultiPart(content);
                if (uuencodedMP.isUUEncoded()) {
                    if (!handler.handleInlineUUEncodedPlainText(uuencodedMP.getCleanText(), contentType, uuencodedMP.getCleanText().length(), fileName, MailMessageParser.getSequenceId(prefix, partCount))) {
                        this.stop = true;
                        return;
                    }
                    int count = uuencodedMP.getCount();
                    if (count <= 0) return;
                    for (int a = 0; a < count; ++a) {
                        if (handler.handleInlineUUEncodedAttachment(uuencodedMP.getBodyPart(a), MailMessageParser.getSequenceId(prefix, ++partCount))) continue;
                        this.stop = true;
                        return;
                    }
                    return;
                }
                if (handler.handleInlinePlainText(content, contentType, size, fileName, MailMessageParser.getSequenceId(prefix, partCount))) return;
                this.stop = true;
                return;
            }
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleAttachment(mailPart, false, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isHtml(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (isInline) {
                if (handler.handleInlineHtml(MailMessageParser.readContent(mailPart, contentType, this.mailId, this.folder), contentType, size, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            if (handler.handleAttachment(mailPart, false, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isImage(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleImagePart(mailPart, mailPart.getContentId(), lcct, isInline, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (MailMessageParser.isMessage(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleNestedMessage(mailPart, MailMessageParser.getSequenceId(prefix, partCount))) return;
            this.stop = true;
            return;
        }
        if (TNEFUtils.isTNEFMimeType((String)lcct)) {
            try {
                List attachments2;
                int s;
                RawInputStream ris;
                Calendar calendar2;
                Multipart mp;
                MAPIProp prop;
                TNEFInputStream tnefInputStream = new TNEFInputStream(mailPart.getInputStream());
                Message message = new Message(tnefInputStream);
                Attr messageClass = message.getAttribute(32776);
                String messageClassName = messageClass == null ? (null == (prop = message.getMAPIProps().getProp(26)) ? "" : prop.getValue().toString()) : (String)messageClass.getValue();
                if (TNEF_IPM_CONTACT.equalsIgnoreCase(messageClassName)) {
                    try {
                        mp = ContactHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)"Invalid TNEF contact", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                if (messageClassName.equalsIgnoreCase(TNEF_IPM_MS_READ_RECEIPT)) {
                    try {
                        mp = ReadReceiptHandler.convert((Message)message);
                    }
                    catch (RuntimeException e) {
                        if (!WARN_ENABLED) return;
                        LOG.warn((Object)"Invalid TNEF read receipt", (Throwable)e);
                        return;
                    }
                    this.parseMailContent(new MimeMailPart(mp), handler, prefix, partCount);
                    return;
                }
                if (TNEF2ICal.isVPart(messageClassName) && null != (calendar2 = TNEF2ICal.tnef2VPart(message))) {
                    TNEFBodyPart part = new TNEFBodyPart();
                    Property method = calendar2.getProperties().getProperty("METHOD");
                    String contentTypeStr = null == method ? "text/calendar; charset=UTF-8" : new StringAllocator("text/calendar; method=").append(method.getValue()).append("; charset=UTF-8").toString();
                    byte[] bytes = calendar2.toString().getBytes(Charsets.UTF_8);
                    part.setDataHandler(new DataHandler((DataSource)new MessageDataSource(bytes, contentTypeStr)));
                    part.setSize(bytes.length);
                    part.setHeader(HDR_CONTENT_TYPE, contentTypeStr);
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(MailMessageParser.getFileName(null, MailMessageParser.getSequenceId(prefix, partCount), "text/calendar"));
                    part.setHeader(HDR_CONTENT_DISPOSITION, cd.toString());
                    part.setHeader("MIME-Version", "1.0");
                    Component vEvent = calendar2.getComponents().getComponent("VEVENT");
                    Property summary = vEvent.getProperties().getProperty("SUMMARY");
                    if (summary != null) {
                        part.setFileName(new StringAllocator(MimeUtility.encodeText((String)summary.getValue().replaceAll("\\s", "_"), (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q")).append(".ics").toString());
                    }
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)part), handler, prefix, partCount++);
                    return;
                }
                Attr attrBody = Attr.findAttr((List)message.getAttributes(), (int)32780);
                if (attrBody != null) {
                    TNEFBodyPart bodyPart = new TNEFBodyPart();
                    String value = (String)attrBody.getValue();
                    MessageUtility.setText(value, (Part)bodyPart);
                    bodyPart.setSize(value.length());
                    this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                }
                TNEFBodyPart rtfPart = null;
                MAPIProps mapiProps = message.getMAPIProps();
                if (mapiProps != null && (ris = (RawInputStream)mapiProps.getPropValue(4105)) != null) {
                    rtfPart = new TNEFBodyPart();
                    byte[] decompressedBytes = CompressedRTFInputStream.decompressRTF((byte[])ris.toByteArray());
                    String contentTypeStr = "application/rtf";
                    rtfPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(decompressedBytes, contentTypeStr)));
                    rtfPart.setHeader(HDR_CONTENT_TYPE, contentTypeStr);
                    rtfPart.setSize(decompressedBytes.length);
                }
                if ((s = (attachments2 = message.getAttachments()).size()) > 0) {
                    Iterator iter = attachments2.iterator();
                    UnsynchronizedByteArrayOutputStream os = new UnsynchronizedByteArrayOutputStream(8192);
                    for (int i = 0; i < s; ++i) {
                        Attachment attachment = (Attachment)iter.next();
                        TNEFBodyPart bodyPart = new TNEFBodyPart();
                        if (attachment.getNestedMessage() == null) {
                            String tmp;
                            bodyPart.setTNEFAttributes(attachment.getAttributes());
                            String attachFilename = attachment.getFilename();
                            String contentTypeStr = null;
                            if (attachment.getMAPIProps() != null) {
                                contentTypeStr = (String)attachment.getMAPIProps().getPropValue(14094);
                            }
                            if (null != contentTypeStr && (tmp = contentTypeStr.toLowerCase(Locale.US)).startsWith(PRIMARY_MULTI) && tmp.indexOf("boundary=") < 0) {
                                MimeMessage nested = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)attachment.getRawData());
                                this.parseMailContent(MimeMessageConverter.convertMessage(nested, false), handler, prefix, partCount++);
                                continue;
                            }
                            if (contentTypeStr == null && attachFilename != null) {
                                contentTypeStr = MimeType2ExtMap.getContentType(attachFilename);
                            }
                            if (contentTypeStr == null) {
                                contentTypeStr = APPL_OCTET;
                            }
                            RawDataSource ds = new RawDataSource(attachment.getRawData(), contentTypeStr);
                            bodyPart.setDataHandler(new DataHandler((DataSource)ds));
                            bodyPart.setHeader(HDR_CONTENT_TYPE, ContentType.prepareContentTypeString(contentTypeStr, attachFilename));
                            if (attachFilename != null) {
                                ContentDisposition cd = new ContentDisposition("attachment");
                                cd.setFilenameParameter(attachFilename);
                                bodyPart.setHeader(HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                            }
                            os.reset();
                            attachment.writeTo((OutputStream)os);
                            bodyPart.setSize(os.size());
                            this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                            continue;
                        }
                        TNEFMimeMessage nestedMessage = TNEFMime.convert((Session)MimeDefaultSession.getDefaultSession(), (Message)attachment.getNestedMessage());
                        os.reset();
                        nestedMessage.writeTo((OutputStream)os);
                        bodyPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(os.toByteArray(), PRIMARY_RFC822)));
                        bodyPart.setHeader(HDR_CONTENT_TYPE, PRIMARY_RFC822);
                        this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                    }
                    return;
                }
                if (null != rtfPart) {
                    MailPart convertedPart = MimeMessageConverter.convertPart((Part)rtfPart);
                    convertedPart.setFileName(new StringAllocator(this.subject.replaceAll("\\s+", "_")).append(".rtf").toString());
                    this.parseMailContent(convertedPart, handler, prefix, partCount++);
                }
                if (null == messageClass) {
                    if (!mailPart.containsSequenceId()) {
                        mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                    }
                    if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                    this.stop = true;
                    return;
                }
                TNEFBodyPart bodyPart = new TNEFBodyPart();
                bodyPart.setTNEFAttributes(message.getAttributes());
                String attachFilename = fileName;
                RawDataSource ds = new RawDataSource(messageClass.getRawData(), APPL_OCTET);
                bodyPart.setDataHandler(new DataHandler((DataSource)ds));
                bodyPart.setHeader(HDR_CONTENT_TYPE, ContentType.prepareContentTypeString(APPL_OCTET, attachFilename));
                if (attachFilename != null) {
                    ContentDisposition cd = new ContentDisposition("attachment");
                    cd.setFilenameParameter(attachFilename);
                    bodyPart.setHeader(HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                }
                bodyPart.setSize(messageClass.getLength());
                this.parseMailContent(MimeMessageConverter.convertPart((Part)bodyPart), handler, prefix, partCount++);
                return;
            }
            catch (IOException tnefExc) {
                if (WARN_ENABLED) {
                    LOG.warn((Object)tnefExc.getMessage(), (Throwable)tnefExc);
                }
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
            catch (MessagingException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                if (!mailPart.containsSequenceId()) {
                    mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
                }
                if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
                this.stop = true;
                return;
            }
        }
        if (MailMessageParser.isSpecial(lcct)) {
            if (!mailPart.containsSequenceId()) {
                mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
            }
            if (handler.handleSpecialPart(mailPart, lcct, fileName, mailPart.getSequenceId())) return;
            this.stop = true;
            return;
        }
        if (!mailPart.containsSequenceId()) {
            mailPart.setSequenceId(MailMessageParser.getSequenceId(prefix, partCount));
        }
        if (handler.handleAttachment(mailPart, isInline, lcct, fileName, mailPart.getSequenceId())) return;
        this.stop = true;
    }

    private void parseEnvelope(MailMessage mail, MailMessageHandler handler) throws OXException {
        int headersSize;
        String subj;
        handler.handleFrom(mail.getFrom());
        handler.handleToRecipient(mail.getTo());
        handler.handleCcRecipient(mail.getCc());
        handler.handleBccRecipient(mail.getBcc());
        this.subject = subj = mail.getSubject();
        handler.handleSubject(subj);
        if (mail.getSentDate() != null) {
            handler.handleSentDate(mail.getSentDate());
        }
        if (mail.getReceivedDate() != null) {
            handler.handleReceivedDate(mail.getReceivedDate());
        }
        handler.handleSystemFlags(mail.getFlags());
        handler.handleUserFlags(mail.getUserFlags());
        handler.handleColorLabel(mail.getColorLabel());
        handler.handlePriority(mail.getPriority());
        if (mail.containsContentId()) {
            handler.handleContentId(mail.getContentId());
        }
        if (mail.getMsgref() != null) {
            handler.handleMsgRef(mail.getMsgref().toString());
        }
        if (mail.containsDispositionNotification() && null != mail.getDispositionNotification()) {
            handler.handleDispositionNotification(mail.getDispositionNotification(), mail.containsPrevSeen() ? mail.isPrevSeen() : mail.isSeen());
        }
        handler.handleHeaders(headersSize, (headersSize = mail.getHeadersSize()) > 0 ? mail.getHeadersIterator() : EMPTY_ITER);
    }

    public static String getFileName(String rawFileName, String sequenceId, String baseMimeType) {
        String filename = rawFileName;
        if (filename == null || MailMessageParser.isEmptyString(filename)) {
            List<String> exts = MimeType2ExtMap.getFileExtensions(baseMimeType.toLowerCase(Locale.ENGLISH));
            StringAllocator sb = new StringAllocator(16).append(PREFIX).append(sequenceId).append('.');
            if (exts == null) {
                sb.append("dat");
            } else {
                sb.append(exts.get(0));
            }
            filename = sb.toString();
        } else {
            filename = MimeMessageUtility.decodeMultiEncodedHeader(filename);
        }
        return filename;
    }

    private static boolean isEmptyString(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static String getSequenceId(String prefix, int partCount) {
        if (prefix == null) {
            return String.valueOf(partCount);
        }
        return new StringAllocator(prefix).append('.').append(partCount).toString();
    }

    public static String generateFilename(String sequenceId, String baseMimeType) {
        return MailMessageParser.getFileName(null, sequenceId, baseMimeType);
    }

    private static String readContent(MailPart mailPart, ContentType contentType, String mailId, String folder) throws OXException, IOException {
        String charset = MailMessageParser.getCharset(mailPart, contentType);
        try {
            if (contentType.startsWith(PRIMARY_HTML)) {
                String html = MessageUtility.readMailPart(mailPart, charset);
                return MessageUtility.simpleHtmlDuplicateRemoval(html);
            }
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "ISO-8859-1";
            if (WARN_ENABLED) {
                LOG.warn((Object)new StringAllocator("Character conversion exception while reading content with charset \"").append(charset).append("\". Using fallback charset \"").append("ISO-8859-1").append("\" instead."), (Throwable)e);
            }
            return MessageUtility.readMailPart(mailPart, "ISO-8859-1");
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(e, mailId, folder);
            }
            throw e;
        }
    }

    private static boolean is7BitTransferEncoding(MailPart mailPart) {
        String transferEncoding = mailPart.getFirstHeader(HDR_CONTENT_TRANSFER_ENC);
        return null == transferEncoding || "7bit".equalsIgnoreCase(transferEncoding.trim());
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader(HDR_CONTENT_TYPE)) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                StringAllocator sb = null;
                if (null != cs) {
                    sb = new StringAllocator(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                    MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
                }
                if (contentType.startsWith(PRIMARY_TEXT)) {
                    cs = CharsetDetector.detectCharset((InputStream)mailPart.getInputStream());
                    if ("US-ASCII".equalsIgnoreCase(cs)) {
                        cs = "ISO-8859-1";
                    }
                    if (WARN_ENABLED && null != sb) {
                        sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    if (WARN_ENABLED && null != sb) {
                        sb.append(" Using fallback encoding: \"").append(cs).append('\"');
                        LOG.warn((Object)sb.toString());
                    }
                }
            }
            charset = cs;
        } else {
            InputStream inputStream;
            charset = contentType.startsWith(PRIMARY_TEXT) ? (null == (inputStream = mailPart.getInputStream()) ? MailProperties.getInstance().getDefaultMimeCharset() : CharsetDetector.detectCharset((InputStream)inputStream)) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    private static boolean isText(String contentType) {
        if (contentType.startsWith(PRIMARY_TEXT, 0)) {
            int off = PRIMARY_TEXT.length();
            for (String subtype : SUB_TEXT) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isHtml(String contentType) {
        return contentType.startsWith(PRIMARY_HTML, 0);
    }

    private static boolean isMultipart(String contentType) {
        return contentType.startsWith(PRIMARY_MULTI, 0);
    }

    private static boolean isImage(String contentType) {
        return contentType.startsWith(PRIMARY_IMAGE, 0);
    }

    private static boolean isMessage(String contentType) {
        return contentType.startsWith(PRIMARY_RFC822, 0);
    }

    private static boolean isSpecial(String contentType) {
        block3: {
            block2: {
                if (!contentType.startsWith(PRIMARY_TEXT, 0)) break block2;
                int off = PRIMARY_TEXT.length();
                for (String subtype : SUB_SPECIAL2) {
                    if (!contentType.startsWith(subtype, off)) continue;
                    return true;
                }
                break block3;
            }
            if (!contentType.startsWith(PRIMARY_MESSAGE, 0)) break block3;
            int off = PRIMARY_MESSAGE.length();
            for (String subtype : SUB_SPECIAL1) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isWinmailDat(String fileName) {
        if (MailMessageParser.isEmptyString(fileName)) {
            return false;
        }
        String toCheck = LocaleTools.toLowerCase((CharSequence)fileName);
        return toCheck.startsWith("winmail", 0) && toCheck.endsWith(".dat");
    }

    private static interface InlineDetector {
        public boolean isInline(String var1, String var2);
    }
}

