/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache.queue;

import com.openexchange.mail.cache.PooledMailAccess;
import com.openexchange.mail.cache.queue.MailAccessQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class SingletonMailAccessQueue
implements MailAccessQueue {
    private final AtomicReference<PooledMailAccess> singleton = new AtomicReference();
    private final AtomicBoolean deprecated = new AtomicBoolean();

    @Override
    public int getCapacity() {
        return 1;
    }

    @Override
    public PooledMailAccess pollDelayed() {
        PooledMailAccess tmp;
        do {
            if (null == (tmp = this.singleton.get()) || tmp.getDelay(TimeUnit.MILLISECONDS) > 0L || !this.singleton.compareAndSet(tmp, null)) continue;
            return tmp;
        } while (!this.singleton.compareAndSet(tmp, tmp));
        return null;
    }

    @Override
    public boolean offer(PooledMailAccess pooledMailAccess) {
        return this.singleton.compareAndSet(null, pooledMailAccess);
    }

    @Override
    public PooledMailAccess poll() {
        return this.singleton.getAndSet(null);
    }

    @Override
    public PooledMailAccess remove() {
        PooledMailAccess tmp;
        while (!this.singleton.compareAndSet(tmp = this.singleton.get(), null)) {
        }
        if (null == tmp) {
            throw new IllegalStateException("Queue is empty.");
        }
        return tmp;
    }

    @Override
    public PooledMailAccess peek() {
        return this.singleton.get();
    }

    @Override
    public PooledMailAccess element() {
        PooledMailAccess tmp = this.singleton.get();
        if (null == tmp) {
            throw new IllegalStateException("Queue is empty.");
        }
        return tmp;
    }

    @Override
    public int size() {
        return null == this.singleton.get() ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return null == this.singleton.get();
    }

    @Override
    public boolean contains(Object o) {
        PooledMailAccess tmp = this.singleton.get();
        if (null == tmp) {
            return null == o;
        }
        return tmp.equals(o);
    }

    @Override
    public Iterator<PooledMailAccess> iterator() {
        PooledMailAccess tmp = this.singleton.get();
        List<Object> list = null == tmp ? Collections.emptyList() : Collections.singletonList(tmp);
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        PooledMailAccess tmp = this.singleton.get();
        List<Object> list = null == tmp ? Collections.emptyList() : Collections.singletonList(tmp);
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        PooledMailAccess tmp = this.singleton.get();
        List<Object> list = null == tmp ? Collections.emptyList() : Collections.singletonList(tmp);
        return list.toArray(a);
    }

    @Override
    public boolean add(PooledMailAccess pooledMailAccess) {
        return this.singleton.compareAndSet(null, pooledMailAccess);
    }

    @Override
    public boolean remove(Object o) {
        PooledMailAccess tmp = this.singleton.get();
        if (null == tmp) {
            return false;
        }
        return tmp.equals(o) && this.singleton.compareAndSet(tmp, null);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (null == c || c.isEmpty()) {
            return false;
        }
        if (c.size() > 1) {
            return false;
        }
        Object o = c.iterator().next();
        PooledMailAccess tmp = this.singleton.get();
        if (null == tmp) {
            return null == o;
        }
        return tmp.equals(o);
    }

    @Override
    public boolean addAll(Collection<? extends PooledMailAccess> c) {
        if (null == c || c.isEmpty()) {
            return false;
        }
        return this.offer(c.iterator().next());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (null == c || c.isEmpty()) {
            return false;
        }
        Object o = c.iterator().next();
        return this.remove(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (null == c || c.isEmpty()) {
            return false;
        }
        Object o = c.iterator().next();
        if (!(o instanceof PooledMailAccess)) {
            return false;
        }
        PooledMailAccess tmp = (PooledMailAccess)o;
        do {
            if (tmp.equals(this.singleton.get()) || !this.singleton.compareAndSet(tmp, null)) continue;
            return true;
        } while (!this.singleton.compareAndSet(tmp, tmp));
        return false;
    }

    @Override
    public void clear() {
        this.singleton.set(null);
    }

    @Override
    public void markDeprecated() {
        this.deprecated.set(true);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated.get();
    }
}

