/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class UniversalCache<K, V> {
    private final ConcurrentMap<K, Future<V>> map = new ConcurrentHashMap<K, Future<V>>();
    private final ValueYielder<K, V> yielder;

    public UniversalCache(ValueYielder<K, V> yielder) {
        this.yielder = yielder;
    }

    /*
     * Loose catch block
     */
    public V get(K k) throws InterruptedException {
        while (true) {
            FutureTask tmp;
            FutureTask f;
            if ((f = (FutureTask)this.map.get(k)) == null && (f = (Future)this.map.putIfAbsent(k, tmp = new FutureTask(new UCCallable<K, V>(k, this.yielder)))) == null) {
                f = tmp;
                tmp.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.map.remove(k);
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw UniversalCache.launderThrowable(e.getCause());
        }
    }

    public void clear() {
        this.map.clear();
    }

    private static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }

    private static final class UCCallable<K, V>
    implements Callable<V> {
        private final ValueYielder<K, V> yielder;
        private final K input;

        public UCCallable(K input, ValueYielder<K, V> yielder) {
            this.input = input;
            this.yielder = yielder;
        }

        @Override
        public V call() throws Exception {
            return this.yielder.yieldValue(this.input);
        }
    }

    public static interface ValueYielder<K, V> {
        public V yieldValue(K var1);
    }
}

