/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class MailAccessWatcher {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailAccessWatcher.class));
    private static final ConcurrentMap<MailAccess<?, ?>, Long> MAIL_ACCESSES = new NonBlockingHashMap();
    private static boolean initialized = false;
    private static volatile ScheduledTimerTask watcherTask;

    static synchronized void init() {
        if (initialized) {
            return;
        }
        if (MailProperties.getInstance().isWatcherEnabled()) {
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                int frequencyMillis = MailProperties.getInstance().getWatcherFrequency();
                watcherTask = timer.scheduleWithFixedDelay((Runnable)new WatcherTask(MAIL_ACCESSES, LOG), 1000L, (long)frequencyMillis);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Mail connection watcher successfully established and ready for tracing");
            }
        }
        initialized = true;
    }

    static synchronized void stop() {
        if (!initialized) {
            return;
        }
        if (MailProperties.getInstance().isWatcherEnabled()) {
            if (null != watcherTask) {
                watcherTask.cancel(false);
                TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
                if (null != timer) {
                    timer.purge();
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Mail connection watcher successfully stopped");
            }
        }
        MAIL_ACCESSES.clear();
        initialized = false;
    }

    private MailAccessWatcher() {
    }

    public static void addMailAccess(MailAccess<?, ?> mailAccess) {
        MAIL_ACCESSES.put(mailAccess, System.currentTimeMillis());
    }

    public static void removeMailAccess(MailAccess<?, ?> mailAccess) {
        MAIL_ACCESSES.remove(mailAccess);
    }

    public static int getNumberOfMailAccesses() {
        return MAIL_ACCESSES.size();
    }

    public static int getNumberOfIdlingMailAccesses() {
        int count = 0;
        for (MailAccess mailAccess : MAIL_ACCESSES.keySet()) {
            if (!mailAccess.isConnectedUnsafe() || !mailAccess.isWaiting()) continue;
            ++count;
        }
        return count;
    }

    private static class WatcherTask
    implements Runnable {
        private final ConcurrentMap<MailAccess<?, ?>, Long> map;
        private final Log logger;
        private final boolean traceEnabled;
        private final String lineSeparator;

        public WatcherTask(ConcurrentMap<MailAccess<?, ?>, Long> mailAccesses, Log logger) {
            this.map = mailAccesses;
            this.logger = logger;
            this.traceEnabled = logger.isTraceEnabled();
            this.lineSeparator = System.getProperty("line.separator");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.map.isEmpty()) {
                    return;
                }
                StringBuilder sb = new StringBuilder(512);
                LinkedList<MailAccess> exceededAcesses = new LinkedList<MailAccess>();
                int watcherTime = MailProperties.getInstance().getWatcherTime();
                long now = System.currentTimeMillis();
                Iterator iter = this.map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    MailAccess mailAccess = (MailAccess)e.getKey();
                    if (mailAccess.isConnected()) {
                        long duration;
                        if (mailAccess.isWaiting()) {
                            if (!this.traceEnabled) continue;
                            this.logger.trace((Object)new StringAllocator("Idling/waiting mail connection:").append(this.lineSeparator).append(mailAccess.getTrace()).toString());
                            continue;
                        }
                        Long val = (Long)e.getValue();
                        if (null == val || (duration = now - Autoboxing.l((Long)val)) <= (long)watcherTime) continue;
                        sb.setLength(0);
                        sb.append("UNCLOSED MAIL CONNECTION AFTER ");
                        sb.append(duration).append("msec:");
                        if (com.openexchange.log.Log.appendTraceToMessage()) {
                            sb.append(this.lineSeparator);
                            sb.append(mailAccess.getTrace());
                            this.logger.info((Object)sb.toString());
                        } else {
                            mailAccess.logTrace(sb, this.logger);
                        }
                        exceededAcesses.add(mailAccess);
                        continue;
                    }
                    iter.remove();
                }
                if (!exceededAcesses.isEmpty()) {
                    if (MailProperties.getInstance().isWatcherShallClose()) {
                        for (MailAccess mailAccess : exceededAcesses) {
                            try {
                                sb.setLength(0);
                                sb.append("CLOSING MAIL CONNECTION BY WATCHER:").append(this.lineSeparator).append(mailAccess.toString());
                                mailAccess.close(false);
                                sb.append(this.lineSeparator).append("    DONE");
                                this.logger.info((Object)sb.toString());
                            }
                            finally {
                                this.map.remove(mailAccess);
                            }
                        }
                    } else {
                        for (MailAccess mailAccess : exceededAcesses) {
                            this.map.remove(mailAccess);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

