/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.java.StringAllocator;

public final class IndexRange {
    public static final IndexRange NULL = null;
    public final int start;
    public final int end;

    public IndexRange(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start index is less than zero");
        }
        if (end < 0) {
            throw new IllegalArgumentException("end index is less than zero");
        }
        if (end < start) {
            throw new IllegalArgumentException("end index is less than start index");
        }
        this.start = start;
        this.end = end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRange other = (IndexRange)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return new StringAllocator(super.toString()).append(" start=").append(this.start).append(", end=").append(this.end).toString();
    }
}

