/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.authentication.ResultCode;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class LoginResultImpl
implements LoginResult {
    private LoginRequest request;
    private Context context;
    private User user;
    private Session session;
    private final List<OXException> warnings;
    private ResultCode code;
    private String redirect;
    private Cookie[] cookies;
    private Header[] headers;
    private String serverToken;

    LoginResultImpl() {
        this.warnings = new LinkedList<OXException>();
    }

    public LoginResultImpl(Session session, Context context, User user) {
        this.session = session;
        this.context = context;
        this.user = user;
        this.warnings = new LinkedList<OXException>();
    }

    @Override
    public LoginRequest getRequest() {
        return this.request;
    }

    void setRequest(LoginRequest request) {
        this.request = request;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies;
    }

    void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    @Override
    public Header[] getHeaders() {
        return this.headers;
    }

    @Override
    public String getRedirect() {
        return this.redirect;
    }

    @Override
    public ResultCode getCode() {
        return this.code;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public void setCode(ResultCode code) {
        this.code = code;
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public Collection<OXException> warnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @Override
    public void addWarning(OXException warning) {
        warning.setCategory(Category.CATEGORY_WARNING);
        this.warnings.add(warning);
    }

    @Override
    public void addWarnings(Collection<? extends OXException> warnings) {
        for (OXException oXException : warnings) {
            oXException.setCategory(Category.CATEGORY_WARNING);
        }
        this.warnings.addAll(warnings);
    }

    @Override
    public String getServerToken() {
        return this.serverToken;
    }

    public void setServerToken(String serverToken) {
        this.serverToken = serverToken;
    }
}

