/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.StatusReplacement;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;

public final class ParticipantsReplacement
implements TemplateReplacement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ParticipantsReplacement.class));
    private static final String CRLF = "\r\n";
    private boolean changed;
    private Locale locale;
    private StringHelper stringHelper;
    private SortedSet<EmailableParticipant> participantsSet;

    public ParticipantsReplacement(SortedSet<EmailableParticipant> participantsSet) {
        this.participantsSet = participantsSet;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    public Object clone() throws CloneNotSupportedException {
        ParticipantsReplacement clone = (ParticipantsReplacement)super.clone();
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        clone.stringHelper = null;
        clone.participantsSet = new TreeSet<EmailableParticipant>();
        for (EmailableParticipant p : this.participantsSet) {
            clone.participantsSet.add((EmailableParticipant)p.clone());
        }
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public boolean relevantChange() {
        if (!this.changed) {
            return false;
        }
        for (EmailableParticipant participant : this.participantsSet) {
            if (participant.state == 1) {
                return true;
            }
            if (participant.state != -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getReplacement() {
        if (this.participantsSet.isEmpty()) {
            return "";
        }
        int size = this.participantsSet.size();
        StringBuilder b = new StringBuilder(size << 5);
        Locale l = this.getLocale();
        StringHelper stringHelper = this.getStringHelper();
        Iterator iter = this.participantsSet.iterator();
        boolean added = this.processParticipant(b, l, stringHelper, (EmailableParticipant)iter.next());
        for (int i = 1; i < size; ++i) {
            if (added) {
                b.append(CRLF);
            }
            added = this.processParticipant(b, l, stringHelper, (EmailableParticipant)iter.next());
        }
        return b.toString();
    }

    private boolean processParticipant(StringBuilder b, Locale l, StringHelper stringHelper, EmailableParticipant participant) {
        String name = participant.displayName;
        if (name == null) {
            name = participant.email;
        }
        if (this.changed) {
            if (participant.state == 1) {
                b.append("* ").append(stringHelper.getString("Added")).append(": ");
                b.append(name);
                this.appendStatus(b, l, stringHelper, participant);
            } else if (participant.state == -1) {
                b.append("* ").append(stringHelper.getString("Removed")).append(": ");
                b.append(name);
            } else {
                b.append(name);
                this.appendStatus(b, l, stringHelper, participant);
            }
            return true;
        }
        if (participant.state != -1) {
            b.append(name);
            this.appendStatus(b, l, stringHelper, participant);
            return true;
        }
        return false;
    }

    private void appendStatus(StringBuilder b, Locale l, StringHelper stringHelper, EmailableParticipant participant) {
        if (participant.type == 1) {
            b.append(" (");
            b.append(new StatusReplacement(participant.confirm, l).getReplacement());
            if (!ParticipantsReplacement.isEmpty(participant.confirmMessage)) {
                b.append(": ").append(participant.confirmMessage);
            }
            b.append(')');
        } else if (participant.type == 5) {
            b.append(" (");
            b.append(stringHelper.getString("external"));
            b.append(')');
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.PARTICIPANTS;
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.ENGLISH;
        }
        return this.locale;
    }

    private StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = StringHelper.valueOf(this.getLocale());
        }
        return this.stringHelper;
    }

    @Override
    public TemplateReplacement setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        this.stringHelper = null;
        return this;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!ParticipantsReplacement.class.isInstance(other)) {
            return false;
        }
        if (!TemplateToken.PARTICIPANTS.equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        ParticipantsReplacement o = (ParticipantsReplacement)other;
        this.changed = true;
        if (this.participantsSet == null || o.participantsSet != null) {
            this.participantsSet = o.participantsSet;
        }
        return true;
    }
}

