/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.internal.SchemaImpl;
import java.util.HashSet;
import java.util.Set;

public class SchemaUpdateStateImpl
extends SchemaImpl
implements SchemaUpdateState {
    private static final long serialVersionUID = -2760325392823131336L;
    private final Set<String> executedTasks = new HashSet<String>();
    private boolean backgroundUpdatesRunning;

    SchemaUpdateStateImpl() {
    }

    public SchemaUpdateStateImpl(SchemaUpdateState schema) {
        super(schema);
        for (String task : schema.getExecutedList()) {
            this.executedTasks.add(task);
        }
        this.backgroundUpdatesRunning = schema.backgroundUpdatesRunning();
    }

    @Override
    public void addExecutedTask(String taskName) {
        this.executedTasks.add(taskName);
    }

    @Override
    public boolean isExecuted(String taskName) {
        return this.executedTasks.contains(taskName);
    }

    @Override
    public String[] getExecutedList() {
        return this.executedTasks.toArray(new String[this.executedTasks.size()]);
    }

    @Override
    public boolean backgroundUpdatesRunning() {
        return this.backgroundUpdatesRunning;
    }

    void setBackgroundUpdatesRunning(boolean backgroundUpdatesRunning) {
        this.backgroundUpdatesRunning = backgroundUpdatesRunning;
    }
}

