/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify.hostname.internal;

import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.login.BlockingLoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import com.openexchange.systemname.SystemNameService;
import java.util.concurrent.atomic.AtomicReference;

public final class HostDataLoginHandler
implements BlockingLoginHandlerService {
    private final AtomicReference<HostnameService> hostnameService = new AtomicReference();
    private final AtomicReference<SystemNameService> systemNameService = new AtomicReference();

    @Override
    public void handleLogin(LoginResult login) {
        LoginRequest request = login.getRequest();
        Session session = login.getSession();
        HostDataImpl hostData = new HostDataImpl(request.isSecure(), this.determineHost(request, session.getContextId(), session.getUserId()), request.getServerPort(), this.determineHttpSessionId(request.getHttpSessionID()));
        session.setParameter("com.openexchange.groupware.hostdata", (Object)hostData);
    }

    private String determineHost(LoginRequest request, int contextId, int userId) {
        String tmp;
        String host = request.getServerName();
        HostnameService hostnameService = this.hostnameService.get();
        if (null != hostnameService && null != (tmp = hostnameService.getHostname(userId, contextId))) {
            host = tmp;
        }
        return host;
    }

    private String determineHttpSessionId(String httpSessionId) {
        String retval;
        if (null == httpSessionId) {
            SystemNameService systemNameService = this.systemNameService.get();
            retval = "0123456789." + (null == systemNameService ? "Open-Xchange" : systemNameService.getSystemName());
        } else if (httpSessionId.indexOf(46) > 0) {
            retval = httpSessionId;
        } else {
            SystemNameService systemNameService = this.systemNameService.get();
            retval = httpSessionId + '.' + (null == systemNameService ? "Open-Xchange" : systemNameService.getSystemName());
        }
        return retval;
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }

    public void setHostnameService(HostnameService hostnameService) {
        this.hostnameService.set(hostnameService);
    }

    public void setSystemNameService(SystemNameService systemNameService) {
        this.systemNameService.set(systemNameService);
    }
}

