/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarFolderObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;

public final class CalendarCache {
    private static volatile CalendarCache instance;
    private static final String CACHE_NAME = "CalendarCache";
    private static final org.apache.commons.logging.Log LOG;
    private Cache jcs;

    private CalendarCache() {
        try {
            try {
                this.jcs = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_NAME);
            }
            catch (OXException ce) {
                LOG.error((Object)"CalendarCache could not be initialized!", (Throwable)ce);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"CalendarCache could not be initialized!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalendarCache getInstance() {
        if (instance != null) return instance;
        Class<CalendarCache> clazz = CalendarCache.class;
        synchronized (CalendarCache.class) {
            if (instance != null) return instance;
            instance = new CalendarCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void add(Object key, String groupKey, Object o) throws OXException {
        this.jcs.putInGroup((Serializable)key, groupKey, (Serializable)o, false);
    }

    public Object get(Object key, String groupKey) {
        return this.jcs.getFromGroup((Serializable)key, groupKey);
    }

    public void clear() throws OXException {
        this.jcs.clear();
    }

    public void invalidateGroup(int cid) {
        this.jcs.invalidateGroup(CalendarFolderObject.createGroupKeyFromContextID(cid));
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    static {
        LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarCache.class));
    }
}

