/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.GroupTools;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteRegistry;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class Delete {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Delete.class));
    private final Context ctx;
    private final User user;
    private final int groupId;
    private final Date lastRead;
    private static final GroupStorage storage = GroupStorage.getInstance();
    private transient Group orig;

    Delete(Context ctx, User user, int groupId, Date lastRead) {
        this.ctx = ctx;
        this.user = user;
        this.groupId = groupId;
        this.lastRead = lastRead;
    }

    Group getOrig() throws OXException {
        if (null == this.orig) {
            this.orig = storage.getGroup(this.groupId, this.ctx);
        }
        return this.orig;
    }

    void perform() throws OXException {
        this.allowed();
        this.check();
        this.delete();
        this.propagate();
        this.sentEvent();
    }

    private void allowed() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditGroup()) {
            throw GroupExceptionCodes.NO_DELETE_PERMISSION.create();
        }
        if (this.groupId == GroupTools.GROUP_ZERO.getIdentifier()) {
            try {
                throw GroupExceptionCodes.NO_GROUP_DELETE.create(GroupTools.getGroupZero(this.ctx).getDisplayName());
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw GroupExceptionCodes.NO_GROUP_DELETE.create(Autoboxing.I((int)0));
            }
        }
    }

    private void check() throws OXException {
        this.getOrig();
        if (0 == this.groupId || 1 == this.groupId) {
            throw GroupExceptionCodes.NO_GROUP_DELETE.create(this.getOrig().getDisplayName());
        }
    }

    private void delete() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.propagateDelete(con);
            this.delete(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    private void propagateDelete(Connection con) throws OXException {
        DeleteEvent event = new DeleteEvent((Object)this.getOrig(), this.groupId, 2, this.ctx);
        DeleteRegistry.getInstance().fireDeleteEvent(event, con, con);
    }

    private void delete(Connection con) throws OXException {
        storage.deleteMember(this.ctx, con, this.getOrig(), this.getOrig().getMember());
        storage.deleteGroup(this.ctx, con, this.groupId, this.lastRead);
        Group del = new Group();
        Group orig = this.getOrig();
        del.setIdentifier(orig.getIdentifier());
        del.setDisplayName(orig.getDisplayName());
        del.setSimpleName(orig.getSimpleName());
        del.setLastModified(new Date());
        storage.insertGroup(this.ctx, con, del, GroupStorage.StorageType.DELETED);
    }

    private void propagate() throws OXException {
        UserStorage storage = UserStorage.getInstance();
        storage.invalidateUser(this.ctx, this.getOrig().getMember());
    }

    private void sentEvent() {
        EventAdmin eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class);
        if (null != eventAdmin) {
            Hashtable<String, Integer> dict = new Hashtable<String, Integer>(4);
            ((Dictionary)dict).put("contextId", this.ctx.getContextId());
            ((Dictionary)dict).put("userId", this.user.getId());
            ((Dictionary)dict).put("groupId", this.groupId);
            eventAdmin.postEvent(new Event("com/openexchange/groupware/group/delete", dict));
        }
    }
}

