/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.messaging.DefaultFolderFullnameProvider;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.MessagingPermissionImpl;
import com.openexchange.folderstorage.messaging.contentType.DraftsContentType;
import com.openexchange.folderstorage.messaging.contentType.MessagingContentType;
import com.openexchange.folderstorage.messaging.contentType.SentContentType;
import com.openexchange.folderstorage.messaging.contentType.SpamContentType;
import com.openexchange.folderstorage.messaging.contentType.TrashContentType;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.messaging.MessagingFolder;
import com.openexchange.messaging.MessagingPermission;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public final class MessagingFolderImpl
extends AbstractFolder {
    private static final long serialVersionUID = 6445442372690458946L;
    private MessagingFolderType messagingFolderType;
    private boolean cacheable;
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private static final Map<IgnoreCaseString, Integer> KNOWN_CAPS;
    private static final Map<MessagingFolder.DefaultFolderType, MessagingFolderType> TYPES;

    public MessagingFolderImpl() {
    }

    public MessagingFolderImpl(MessagingFolder messagingFolder, int accountId, String serviceId, User user, DefaultFolderFullnameProvider fullnameProvider) {
        block20: {
            String value;
            String fullname = messagingFolder.getId();
            this.id = MessagingFolderIdentifier.getFQN(serviceId, accountId, fullname);
            this.name = messagingFolder.getName();
            boolean isRootFolder = messagingFolder.isRootFolder();
            this.parent = isRootFolder ? PRIVATE_FOLDER_ID : MessagingFolderIdentifier.getFQN(serviceId, accountId, messagingFolder.getParentId());
            List messagingPermissions = messagingFolder.getPermissions();
            int size = messagingPermissions.size();
            this.permissions = new Permission[size];
            for (int i = 0; i < size; ++i) {
                this.permissions[i] = new MessagingPermissionImpl((MessagingPermission)messagingPermissions.get(i));
            }
            this.type = SystemType.getInstance();
            this.subscribed = messagingFolder.isSubscribed();
            this.subscribedSubfolders = messagingFolder.hasSubscribedSubfolders();
            this.capabilities = MessagingFolderImpl.parseCaps(messagingFolder.getCapabilities());
            this.summary = value = isRootFolder ? "" : new StringAllocator(16).append('(').append(messagingFolder.getMessageCount()).append('/').append(messagingFolder.getUnreadMessageCount()).append(')').toString();
            this.deefault = 0 == accountId && messagingFolder.isDefaultFolder();
            this.total = messagingFolder.getMessageCount();
            this.nu = messagingFolder.getNewMessageCount();
            this.unread = messagingFolder.getUnreadMessageCount();
            this.deleted = messagingFolder.getDeletedMessageCount();
            if (messagingFolder.containsDefaultFolderType()) {
                this.messagingFolderType = TYPES.get(messagingFolder.getDefaultFolderType());
                switch (this.messagingFolderType) {
                    case DRAFTS: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS);
                        break;
                    }
                    case SENT: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT);
                        break;
                    }
                    case SPAM: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM);
                        break;
                    }
                    case TRASH: {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH);
                        break;
                    }
                }
            } else if (messagingFolder.isRootFolder()) {
                this.messagingFolderType = MessagingFolderType.ROOT;
            } else if (null != fullname) {
                try {
                    if (fullname.equals(fullnameProvider.getDraftsFolder())) {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.DRAFTS);
                        this.messagingFolderType = MessagingFolderType.DRAFTS;
                        break block20;
                    }
                    if (fullname.equals(fullnameProvider.getINBOXFolder())) {
                        this.messagingFolderType = MessagingFolderType.INBOX;
                        break block20;
                    }
                    if (fullname.equals(fullnameProvider.getSentFolder())) {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.SENT);
                        this.messagingFolderType = MessagingFolderType.SENT;
                        break block20;
                    }
                    if (fullname.equals(fullnameProvider.getSpamFolder())) {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.SPAM);
                        this.messagingFolderType = MessagingFolderType.SPAM;
                        break block20;
                    }
                    if (fullname.equals(fullnameProvider.getTrashFolder())) {
                        this.name = StringHelper.valueOf(user.getLocale()).getString(MailStrings.TRASH);
                        this.messagingFolderType = MessagingFolderType.TRASH;
                        break block20;
                    }
                    this.messagingFolderType = MessagingFolderType.NONE;
                }
                catch (OXException e) {
                    com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MessagingFolderImpl.class)).error((Object)e.getMessage(), (Throwable)e);
                    this.messagingFolderType = MessagingFolderType.NONE;
                }
            } else {
                this.messagingFolderType = MessagingFolderType.NONE;
            }
        }
        this.cacheable = !messagingFolder.isDefaultFolder() || !this.messagingFolderType.equals((Object)MessagingFolderType.TRASH);
    }

    @Override
    public Object clone() {
        MessagingFolderImpl clone = (MessagingFolderImpl)super.clone();
        clone.cacheable = this.cacheable;
        return clone;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public ContentType getContentType() {
        return this.messagingFolderType.getContentType();
    }

    @Override
    public int getDefaultType() {
        return this.messagingFolderType.getType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public Type getType() {
        return MailType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }

    public static int parseCaps(Set<String> caps) {
        int retval = 0;
        for (String cap : caps) {
            Integer bit = KNOWN_CAPS.get(IgnoreCaseString.valueOf(cap));
            retval = null == bit ? retval : retval | bit;
        }
        return retval;
    }

    static {
        HashMap<IgnoreCaseString, Integer> m = new HashMap<IgnoreCaseString, Integer>(16);
        m.put(IgnoreCaseString.valueOf("ACL"), 1);
        m.put(IgnoreCaseString.valueOf("PERMISSIONS"), 1);
        m.put(IgnoreCaseString.valueOf("THREAD=REFERENCES"), 2);
        m.put(IgnoreCaseString.valueOf("THREAD_REFERENCES"), 2);
        m.put(IgnoreCaseString.valueOf("THREAD-REFERENCES"), 2);
        m.put(IgnoreCaseString.valueOf("QUOTA"), 4);
        m.put(IgnoreCaseString.valueOf("SORT"), 8);
        m.put(IgnoreCaseString.valueOf("SUBSCRIPTION"), 16);
        m.put(IgnoreCaseString.valueOf("THREAD=ORDEREDSUBJECT"), 32);
        m.put(IgnoreCaseString.valueOf("IMAP4"), 64);
        m.put(IgnoreCaseString.valueOf("IMAP4rev1"), 128);
        m.put(IgnoreCaseString.valueOf("UIDPLUS"), 256);
        m.put(IgnoreCaseString.valueOf("NAMESPACE"), 512);
        m.put(IgnoreCaseString.valueOf("IDLE"), 1024);
        m.put(IgnoreCaseString.valueOf("CHILDREN"), 2048);
        KNOWN_CAPS = Collections.unmodifiableMap(m);
        HashMap<MessagingFolder.DefaultFolderType, MessagingFolderType> m2 = new HashMap<MessagingFolder.DefaultFolderType, MessagingFolderType>(8);
        m2.put(MessagingFolder.DefaultFolderType.CONFIRMED_HAM, MessagingFolderType.NONE);
        m2.put(MessagingFolder.DefaultFolderType.CONFIRMED_SPAM, MessagingFolderType.NONE);
        m2.put(MessagingFolder.DefaultFolderType.DRAFTS, MessagingFolderType.DRAFTS);
        m2.put(MessagingFolder.DefaultFolderType.INBOX, MessagingFolderType.INBOX);
        m2.put(MessagingFolder.DefaultFolderType.NONE, MessagingFolderType.NONE);
        m2.put(MessagingFolder.DefaultFolderType.SENT, MessagingFolderType.SENT);
        m2.put(MessagingFolder.DefaultFolderType.SPAM, MessagingFolderType.SPAM);
        m2.put(MessagingFolder.DefaultFolderType.TRASH, MessagingFolderType.TRASH);
        m2.put(MessagingFolder.DefaultFolderType.MESSAGING, MessagingFolderType.MESSAGING);
        TYPES = Collections.unmodifiableMap(m2);
    }

    private static final class IgnoreCaseString
    implements Serializable,
    Cloneable,
    Comparable<IgnoreCaseString>,
    CharSequence {
        private static final long serialVersionUID = -74324024218963602L;
        private final String s;
        private final int hashcode;

        static IgnoreCaseString valueOf(CharSequence s) {
            return new IgnoreCaseString(((Object)s).toString());
        }

        private IgnoreCaseString(String s) {
            this.s = s;
            this.hashcode = s.toLowerCase(Locale.ENGLISH).hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("CloneNotSupportedException although Cloneable is implemented");
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof IgnoreCaseString) {
                return this.s.equalsIgnoreCase(((IgnoreCaseString)other).s);
            }
            if (other instanceof String) {
                return this.s.equalsIgnoreCase((String)other);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.s;
        }

        public int hashCode() {
            return this.hashcode;
        }

        @Override
        public int compareTo(IgnoreCaseString other) {
            return this.s.compareToIgnoreCase(other.s);
        }

        @Override
        public char charAt(int index) {
            return this.s.charAt(index);
        }

        @Override
        public int length() {
            return this.s.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.s.subSequence(start, end);
        }
    }

    public static enum MessagingFolderType {
        NONE(MessagingContentType.getInstance(), 0),
        ROOT(MessagingContentType.getInstance(), 0),
        INBOX(MessagingContentType.getInstance(), 13),
        DRAFTS(DraftsContentType.getInstance(), 14),
        SENT(SentContentType.getInstance(), 15),
        SPAM(SpamContentType.getInstance(), 16),
        TRASH(TrashContentType.getInstance(), 17),
        MESSAGING(MessagingContentType.getInstance(), 13);

        private final ContentType contentType;
        private final int type;

        private MessagingFolderType(ContentType contentType, int type) {
            this.contentType = contentType;
            this.type = type;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public int getType() {
            return this.type;
        }
    }
}

