/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderFilter;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;

public final class AllVisibleFoldersPerformer
extends AbstractUserizedFolderPerformer {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AllVisibleFoldersPerformer.class));

    public AllVisibleFoldersPerformer(ServerSession session, FolderServiceDecorator decorator) {
        super(session, decorator);
    }

    public AllVisibleFoldersPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public AllVisibleFoldersPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, decorator, folderStorageDiscoverer);
    }

    public AllVisibleFoldersPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder[] doAllVisibleFolders(String treeId, FolderFilter filter) throws OXException {
        FolderStorage rootStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, FolderStorage.ROOT_ID);
        if (null == rootStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, FolderStorage.ROOT_ID);
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (rootStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(rootStorage);
        }
        try {
            ArrayList<UserizedFolder> visibleFolders = new ArrayList<UserizedFolder>();
            ListPerformer listAction = null == this.session ? new ListPerformer(this.user, this.context, this.getDecorator()) : new ListPerformer(this.session, this.getDecorator());
            this.fillSubfolders(treeId, FolderStorage.ROOT_ID, filter, visibleFolders, listAction, openedStorages);
            UserizedFolder[] ret = visibleFolders.toArray(new UserizedFolder[visibleFolders.size()]);
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            if (LOG.isDebugEnabled()) {
                long duration = System.currentTimeMillis() - start;
                LOG.debug((Object)new StringAllocator().append("AllVisibleFolders.doAllVisibleFolders() took ").append(duration).append("msec").toString());
            }
            return ret;
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void fillSubfolders(String treeId, String parentId, FolderFilter filter, List<UserizedFolder> visibleFolders, ListPerformer listAction, Collection<FolderStorage> openedStorages) throws OXException {
        block6: {
            UserizedFolder[] subfolders = this.getSubfolders(treeId, parentId, listAction, openedStorages);
            if (subfolders.length <= 0) break block6;
            if (null == filter) {
                visibleFolders.addAll(Arrays.asList(subfolders));
                for (UserizedFolder subfolder : subfolders) {
                    this.fillSubfolders(treeId, subfolder.getID(), filter, visibleFolders, listAction, openedStorages);
                }
            } else {
                for (int i = 0; i < subfolders.length; ++i) {
                    UserizedFolder subfolder = subfolders[i];
                    if (filter.accept(subfolder)) {
                        visibleFolders.add(subfolder);
                        continue;
                    }
                    subfolders[i] = null;
                }
                for (UserizedFolder subfolder : subfolders) {
                    if (null == subfolder) continue;
                    this.fillSubfolders(treeId, subfolder.getID(), filter, visibleFolders, listAction, openedStorages);
                }
            }
        }
    }

    private UserizedFolder[] getSubfolders(String treeId, String parentId, ListPerformer listAction, Collection<FolderStorage> openedStorages) throws OXException {
        return listAction.doList(treeId, parentId, true, openedStorages, false);
    }
}

