/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.Log;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;

public class APIResponseRenderer
implements ResponseRenderer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(APIResponseRenderer.class));
    private static final String JSONP = "jsonp";
    private static final String CALLBACK = "callback";
    private static final String PLAIN_JSON = "plainJson";
    private static final String INCLUDE_STACK_TRACE_ON_ERROR = "includeStackTraceOnError";
    private static final String SESSION_KEY = "sessionObject";
    private static final char[] JS_FRAGMENT_PART1 = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><script type=\"text/javascript\">(parent.callback_".toCharArray();
    private static final char[] JS_FRAGMENT_PART2 = " || window.opener && window.opener.callback_".toCharArray();
    private static final char[] JS_FRAGMENT_PART3 = ")</script></head></html>".toCharArray();
    private static final String MULTIPART = "multipart/";
    private static final String JS_FRAGMENT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><script type=\"text/javascript\">(parent.callback_**action** || window.opener && window.opener.callback_**action**)(**json**)</script></head></html>";
    private static final Pattern RPL_JSON = Pattern.compile("**json**", 16);
    private static final Pattern RPL_ACTION = Pattern.compile("**action**", 16);

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof Response;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        Boolean plainJson = (Boolean)result.getParameter(PLAIN_JSON);
        Response response = (Response)result.getResultObject();
        if (AJAXRequestDataTools.parseBoolParameter(INCLUDE_STACK_TRACE_ON_ERROR, request)) {
            response.setIncludeStackTraceOnError(true);
        }
        APIResponseRenderer.writeResponse(response, request.getAction(), req, resp, null == plainJson ? false : plainJson);
    }

    protected static ServerSession getSession(ServletRequest req) {
        Object attribute = req.getAttribute(SESSION_KEY);
        if (attribute != null) {
            return (ServerSession)req.getAttribute(SESSION_KEY);
        }
        return null;
    }

    protected static Locale localeFrom(HttpServletRequest req) {
        return APIResponseRenderer.localeFrom(APIResponseRenderer.getSession((ServletRequest)req));
    }

    protected static Locale localeFrom(ServerSession session) {
        if (null == session) {
            return Locale.US;
        }
        return session.getUser().getLocale();
    }

    public static void writeResponse(Response response, String action, HttpServletRequest req, HttpServletResponse resp) {
        APIResponseRenderer.writeResponse(response, action, req, resp, false);
    }

    private static void writeResponse(Response response, String action, HttpServletRequest req, HttpServletResponse resp, boolean plainJson) {
        try {
            if (plainJson) {
                ResponseWriter.write(response, resp.getWriter(), APIResponseRenderer.localeFrom(req));
            } else if (APIResponseRenderer.isMultipartContent(req) || APIResponseRenderer.isRespondWithHTML(req) || req.getParameter(CALLBACK) != null) {
                resp.setContentType("text/html; charset=UTF-8");
                String callback = req.getParameter(CALLBACK);
                if (callback == null) {
                    callback = action;
                }
                PrintWriter writer = resp.getWriter();
                writer.write(JS_FRAGMENT_PART1);
                writer.write(callback);
                writer.write(JS_FRAGMENT_PART2);
                writer.write(callback);
                writer.write(")(");
                ResponseWriter.write(response, new EscapingWriter(writer), APIResponseRenderer.localeFrom(req));
                writer.write(JS_FRAGMENT_PART3);
            } else if (req.getParameter(JSONP) != null) {
                resp.setContentType("text/javascript");
                String call = req.getParameter(JSONP);
                PrintWriter writer = resp.getWriter();
                writer.write(call);
                writer.write(40);
                ResponseWriter.write(response, writer, APIResponseRenderer.localeFrom(req));
                writer.write(41);
            } else {
                ResponseWriter.write(response, resp.getWriter(), APIResponseRenderer.localeFrom(req));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            try {
                resp.sendError(500, "A JSON error occurred: " + e.getMessage());
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static final boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    private static boolean isRespondWithHTML(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter("respondWithHTML"));
    }

    private static String substituteJS(String json, String action) {
        return RPL_ACTION.matcher(RPL_JSON.matcher(JS_FRAGMENT).replaceAll(Strings.quoteReplacement((String)json.replaceAll(Pattern.quote("</"), "<\\/")))).replaceAll(Strings.quoteReplacement((String)action));
    }

    private static final class EscapingWriter
    extends Writer {
        private int prev;
        private final Writer writer;

        protected EscapingWriter(Writer writer) {
            this.writer = writer;
            this.prev = 0;
        }

        @Override
        public void write(int c) throws IOException {
            if (60 == c) {
                this.prev = c;
            } else if (47 == c) {
                if (this.prev > 0) {
                    this.writer.write("<\\/");
                    this.prev = 0;
                } else {
                    this.writer.write(c);
                }
            } else {
                if (this.prev > 0) {
                    this.writer.write(60);
                    this.prev = 0;
                }
                this.writer.write(c);
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(cbuf[i]);
            }
        }

        @Override
        public void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(str.charAt(i));
            }
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            if (csq == null) {
                this.write("null");
            } else {
                this.write(((Object)csq).toString());
            }
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            CharSequence cs = csq == null ? "null" : csq;
            this.write(((Object)cs.subSequence(start, end)).toString());
            return this;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.write(c);
            return this;
        }

        @Override
        public void flush() throws IOException {
            if (60 == this.prev) {
                this.writer.write(60);
                this.prev = 0;
            }
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public String toString() {
            return this.writer.toString();
        }
    }
}

