/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentSet<E>
implements Set<E> {
    private final AtomicReference<Set<E>> ref;

    public ConcurrentSet() {
        this.ref = new AtomicReference(Collections.emptySet());
    }

    public ConcurrentSet(Collection<? extends E> c) {
        this.ref = new AtomicReference<LinkedHashSet<E>>(new LinkedHashSet<E>(c));
    }

    public Set<E> getSnapshot() {
        return Collections.unmodifiableSet(this.ref.get());
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ref.get().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.ref.get().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.ref.get().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ref.get().toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added;
        LinkedHashSet<E> set;
        Set<E> expected;
        do {
            expected = this.ref.get();
            set = new LinkedHashSet<E>(expected);
            added = set.add(e);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        LinkedHashSet<E> set;
        Set<E> expected;
        do {
            expected = this.ref.get();
            set = new LinkedHashSet<E>(expected);
            removed = set.remove(o);
        } while (!this.ref.compareAndSet(expected, set));
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ref.get().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added;
        LinkedHashSet<? extends E> set;
        Set<E> expected;
        do {
            expected = this.ref.get();
            set = new LinkedHashSet<E>(expected);
            added = set.addAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret;
        LinkedHashSet<E> set;
        Set<E> expected;
        do {
            expected = this.ref.get();
            set = new LinkedHashSet<E>(expected);
            ret = set.retainAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret;
        LinkedHashSet<E> set;
        Set<E> expected;
        do {
            expected = this.ref.get();
            set = new LinkedHashSet<E>(expected);
            ret = set.removeAll(c);
        } while (!this.ref.compareAndSet(expected, set));
        return ret;
    }

    @Override
    public void clear() {
        Set set;
        Set<E> expected;
        while (!this.ref.compareAndSet(expected = this.ref.get(), set = Collections.emptySet())) {
        }
    }
}

