/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Charsets {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String UTF_8_NAME = "UTF-8";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final ConcurrentMap<String, Charset> CACHE = new ConcurrentHashMap<String, Charset>();
    private static final int _64K = 65536;
    private static final Set<String> SET_ASCII_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("US-ASCII", "ASCII")));

    private Charsets() {
    }

    public static String toAsciiString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append((char)(bytes[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String toAsciiString(byte[] bytes, int off, int len) {
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length);
        for (int i = 0; i < len; ++i) {
            sb.append((char)(bytes[off + i] & 0xFF));
        }
        return sb.toString();
    }

    public static byte[] toAsciiBytes(CharSequence cs) {
        return Charsets.toAsciiBytes(((Object)cs).toString());
    }

    public static byte[] toAsciiBytes(String str) {
        if (null == str) {
            return null;
        }
        int length = str.length();
        if (0 == length) {
            return new byte[0];
        }
        byte[] ret = new byte[length];
        str.getBytes(0, length, ret, 0);
        return ret;
    }

    public static void writeAsciiBytes(String str, OutputStream out) throws IOException {
        if (null == str) {
            return;
        }
        int length = str.length();
        if (0 == length) {
            return;
        }
        if (length <= 65536) {
            for (int i = 0; i < length; ++i) {
                out.write((byte)str.charAt(i++));
            }
        } else {
            byte[] ret = new byte[length];
            str.getBytes(0, length, ret, 0);
            out.write(ret, 0, length);
        }
    }

    public static boolean isAsciiCharset(String charset) {
        if (null == charset) {
            return false;
        }
        return SET_ASCII_NAMES.contains(charset.toUpperCase());
    }

    public static Charset forName(String charsetName) {
        Charset ncs;
        Charset cs = (Charset)CACHE.get(charsetName);
        if (null == cs && null == (cs = CACHE.putIfAbsent(charsetName, ncs = Charset.forName(charsetName)))) {
            cs = ncs;
        }
        return cs;
    }

    public static String toString(byte[] bytes, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static byte[] getBytes(String source, Charset charset) {
        ByteBuffer buf = charset.encode(CharBuffer.wrap(source));
        byte[] retval = new byte[buf.limit()];
        buf.get(retval);
        return retval;
    }
}

