/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Set;
import org.json.HTTPTokener;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.helpers.StringAllocator;

public class HTTP {
    public static final String CRLF = "\r\n";
    private static final String HEADER_HTTP_VERSION = "HTTP-Version";
    private static final String HEADER_STATUS_CODE = "Status-Code";
    private static final String HEADER_REASON_PHRASE = "Reason-Phrase";
    private static final String HEADER_METHOD = "Method";
    private static final String HEADER_REQ_URI = "Request-URI";

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject o = new JSONObject();
        HTTPTokener x = new HTTPTokener(string);
        String t = x.nextToken();
        if (t.toUpperCase().startsWith("HTTP")) {
            o.put(HEADER_HTTP_VERSION, t);
            o.put(HEADER_STATUS_CODE, x.nextToken());
            o.put(HEADER_REASON_PHRASE, x.nextTo('\u0000'));
            x.next();
        } else {
            o.put(HEADER_METHOD, t);
            o.put(HEADER_REQ_URI, x.nextToken());
            o.put(HEADER_HTTP_VERSION, x.nextToken());
        }
        while (x.more()) {
            String name = x.nextTo(':');
            x.next(':');
            o.put(name, x.nextTo('\u0000'));
            x.next();
        }
        return o;
    }

    public static String toString(JSONObject o) throws JSONException {
        Set<String> keys = o.keySet();
        StringAllocator sb = new StringAllocator();
        if (o.has(HEADER_STATUS_CODE) && o.has(HEADER_REASON_PHRASE)) {
            sb.append(o.getString(HEADER_HTTP_VERSION));
            sb.append(' ');
            sb.append(o.getString(HEADER_STATUS_CODE));
            sb.append(' ');
            sb.append(o.getString(HEADER_REASON_PHRASE));
        } else if (o.has(HEADER_METHOD) && o.has(HEADER_REQ_URI)) {
            sb.append(o.getString(HEADER_METHOD));
            sb.append(' ');
            sb.append('\"');
            sb.append(o.getString(HEADER_REQ_URI));
            sb.append('\"');
            sb.append(' ');
            sb.append(o.getString(HEADER_HTTP_VERSION));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        sb.append(CRLF);
        for (String s : keys) {
            if (s.equals(HEADER_HTTP_VERSION) || s.equals(HEADER_STATUS_CODE) || s.equals(HEADER_REASON_PHRASE) || s.equals(HEADER_METHOD) || s.equals(HEADER_REQ_URI) || o.isNull(s)) continue;
            sb.append(s);
            sb.append(": ");
            sb.append(o.getString(s));
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

