/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.task;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.TaskTest;

public class PermissionTest
extends TaskTest {
    public PermissionTest(String name) {
        super(name);
    }

    public void testDummy() {
    }

    public void testInsertTaskInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertTaskInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testInsertTaskInPrivateFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        try {
            PermissionTest.insertTask(this.getSecondWebConversation(), taskObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testInsertTaskInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertTaskInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testInsertTaskInPublicFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        try {
            PermissionTest.insertTask(this.getSecondWebConversation(), taskObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateTaskInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertTaskInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testInsertTaskInPrivateFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        int taskObjectId = PermissionTest.insertTask(this.getWebConversation(), taskObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        taskObj.setObjectID(taskObjectId);
        try {
            PermissionTest.updateTask(this.getSecondWebConversation(), taskObj, taskObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateTaskInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testUpdateTaskInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testUpdateTaskInPublicFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        int taskObjectId = PermissionTest.insertTask(this.getWebConversation(), taskObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        taskObj.setObjectID(taskObjectId);
        try {
            PermissionTest.updateTask(this.getSecondWebConversation(), taskObj, taskObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteTaskInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteTaskInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testDeleteTaskInPrivateFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        int taskObjectId = PermissionTest.insertTask(this.getWebConversation(), taskObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        taskObj.setObjectID(taskObjectId);
        try {
            PermissionTest.deleteTask(this.getSecondWebConversation(), taskObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteTaskInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteTaskInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Task taskObj = new Task();
        taskObj.setTitle("testDeleteTaskInPublicFolderWithoutPermission");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(parentFolderId);
        int taskObjectId = PermissionTest.insertTask(this.getWebConversation(), taskObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        taskObj.setObjectID(taskObjectId);
        try {
            PermissionTest.deleteTask(this.getSecondWebConversation(), taskObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

