/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ApacheURLDecoder;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;

public class ApacheURLDecoderTest
extends TestCase {
    ApacheURLDecoder decoder = new ApacheURLDecoder();

    public void testDecodePlus() throws UnsupportedEncodingException {
        this.assertDecodes("Hallo", "Hallo");
        this.assertDecodes("Hallo%20Welt", "Hallo Welt");
        this.assertDecodes("Hallo+Welt", "Hallo+Welt");
        this.assertDecodes("Hallo++Welt", "Hallo++Welt");
        this.assertDecodes("+Hallo++Welt+", "+Hallo++Welt+");
        this.assertDecodes("Hallo%20Welt+Wie%20Geht%20es+", "Hallo Welt+Wie Geht es+");
    }

    private void assertDecodes(String string, String string2) throws UnsupportedEncodingException {
        ApacheURLDecoderTest.assertEquals((String)string2, (String)this.decoder.decode(string, "UTF-8"));
    }
}

