/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.meterware.httpunit.Base64;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.test.WebdavInit;
import com.openexchange.webdav.xml.GroupUserTest;
import com.openexchange.webdav.xml.framework.Constants;
import java.util.Properties;
import junit.framework.TestCase;
import org.jdom2.Namespace;

public abstract class AbstractWebdavTest
extends TestCase {
    protected static final String PROTOCOL = "http://";
    protected static final String webdavPropertiesFile = "webdavPropertiesFile";
    protected static final String propertyHost = "hostname";
    protected static final Namespace webdav = Constants.NS_DAV;
    protected String hostName = "localhost";
    protected String login = null;
    protected String password = null;
    protected String secondlogin = null;
    protected String context;
    protected int userId = -1;
    protected Properties webdavProps = null;
    protected String authData = null;
    protected WebRequest req = null;
    protected WebResponse resp = null;
    protected WebConversation webCon = null;
    protected WebConversation secondWebCon = null;
    protected static final int dayInMillis = 86400000;
    public static final String AUTHORIZATION = "authorization";

    public AbstractWebdavTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.webCon = new WebConversation();
        this.secondWebCon = new WebConversation();
        this.webdavProps = WebdavInit.getWebdavProperties();
        this.login = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"login", (String)"");
        this.password = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"password", (String)"");
        this.context = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"contextName", (String)"defaultcontext");
        this.secondlogin = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"secondlogin", (String)"");
        this.hostName = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)propertyHost, (String)"localhost");
        this.userId = GroupUserTest.getUserId(this.getWebConversation(), PROTOCOL + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        AbstractWebdavTest.assertTrue((String)"user not found", (this.userId != -1 ? 1 : 0) != 0);
        this.authData = AbstractWebdavTest.getAuthData(this.login, this.password, this.context);
    }

    protected static String getAuthData(String login, String password, String context) throws Exception {
        if (password == null) {
            password = "";
        }
        if (context != null && context.length() > 0) {
            login = login + "@" + context;
        }
        return new String(Base64.encode((String)(login + ":" + password)));
    }

    protected WebConversation getWebConversation() {
        return this.webCon;
    }

    protected WebConversation getNewWebConversation() {
        return new WebConversation();
    }

    protected WebConversation getSecondWebConversation() {
        return this.secondWebCon;
    }

    protected String getHostName() {
        return this.hostName;
    }

    protected String getLogin() {
        return this.login;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getSecondLogin() {
        return this.secondlogin;
    }
}

