/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.util.HashMap;
import java.util.Map;

public class GroupFixtureFactory
implements FixtureFactory<Group> {
    private final FixtureLoader fixtureLoader;

    public GroupFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Group> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new GroupFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class GroupFixtures
    extends DefaultFixtures<Group>
    implements Fixtures<Group> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Group>> groupMap;

        public GroupFixtures(String fixtureName, Map<String, Map<String, String>> values, FixtureLoader fixtureLoader) {
            super(Group.class, values, fixtureLoader);
            this.groupMap = new HashMap<String, Fixture<Group>>();
            this.entries = values;
        }

        @Override
        public Fixture<Group> getEntry(String entryName) throws OXException {
            if (this.groupMap.containsKey(entryName)) {
                return this.groupMap.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            Group group = new Group();
            this.apply(group, values);
            Fixture<Group> fixture = new Fixture<Group>(group, values.keySet().toArray(new String[values.size()]), values);
            this.groupMap.put(entryName, fixture);
            return fixture;
        }
    }
}

