/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.setuptools;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class TestFolderToolkit {
    public int getStandardFolder(int user, Context ctx) {
        FolderObject fo = this.getStandardFolderObject(user, ctx);
        if (fo == null) {
            return -1;
        }
        return fo.getObjectID();
    }

    private FolderObject getStandardFolderObject(int user, Context ctx) {
        OXFolderAccess access = new OXFolderAccess(ctx);
        FolderObject fo = null;
        try {
            fo = access.getDefaultFolder(user, 2);
        }
        catch (OXException e) {
            e.printStackTrace();
            return null;
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject createPublicFolderFor(Session session, Context ctx, String name, int parent, int ... users) {
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)session, (Connection)writecon, (Connection)writecon);
            ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>(users.length);
            for (int user : users) {
                OCLPermission oclp = new OCLPermission();
                oclp.setEntity(user);
                oclp.setAllPermission(128, 128, 128, 128);
                oclp.setFolderAdmin(true);
                permissions.add(oclp);
            }
            FolderObject fo = new FolderObject();
            fo.setFolderName(name);
            fo.setParentFolderID(parent);
            fo.setModule(2);
            fo.setType(2);
            fo.setPermissions(permissions);
            FolderObject folderObject = fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            return folderObject;
        }
        catch (OXException e) {
            e.printStackTrace();
            FolderObject folderObject = null;
            return folderObject;
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)ctx, (Connection)writecon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject createPrivateFolderForSessionUser(Session session, Context ctx, String name, int parent) {
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)session, (Connection)writecon, (Connection)writecon);
            ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>(1);
            OCLPermission oclp = new OCLPermission();
            oclp.setEntity(session.getUserId());
            oclp.setAllPermission(128, 128, 128, 128);
            oclp.setFolderAdmin(true);
            permissions.add(oclp);
            FolderObject fo = new FolderObject();
            fo.setFolderName(name);
            fo.setParentFolderID(parent);
            fo.setModule(2);
            fo.setType(1);
            fo.setPermissions(permissions);
            FolderObject folderObject = fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            return folderObject;
        }
        catch (OXException e) {
            e.printStackTrace();
            FolderObject folderObject = null;
            return folderObject;
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)ctx, (Connection)writecon);
            }
        }
    }

    public void removeAll(Session session, List<FolderObject> cleanFolders) {
        try {
            OXFolderManager oxma = OXFolderManager.getInstance((Session)session, (AppointmentSQLInterface)new CalendarSql(session));
            for (FolderObject folder : cleanFolders) {
                oxma.deleteFolder(folder, true, System.currentTimeMillis());
            }
        }
        catch (OXException e) {
            e.printStackTrace();
        }
    }

    public void sharePrivateFolder(Session session, Context ctx, int otherUserId) {
        FolderObject fo = this.getStandardFolderObject(session.getUserId(), ctx);
        this.sharePrivateFolder(session, ctx, otherUserId, fo);
    }

    public void sharePrivateFolder(Session session, Context ctx, int otherUserId, FolderObject folder) {
        OCLPermission oclp = new OCLPermission();
        oclp.setAllPermission(128, 128, 128, 128);
        this.sharePrivateFolder(session, ctx, otherUserId, folder, oclp);
    }

    public void sharePrivateFolder(Session session, Context ctx, int otherUserId, FolderObject folder, OCLPermission oclp) {
        boolean mustAdd = true;
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>(folder.getPermissions());
        int size = permissions.size();
        for (int i = 0; i < size && mustAdd; ++i) {
            OCLPermission permission = (OCLPermission)permissions.get(i);
            if (permission.getEntity() != otherUserId) continue;
            mustAdd = false;
            permission.setAllPermission(oclp.getFolderPermission(), oclp.getReadPermission(), oclp.getWritePermission(), oclp.getDeletePermission());
        }
        if (mustAdd) {
            oclp.setEntity(otherUserId);
            permissions.add(oclp);
        }
        folder.setPermissions(permissions);
        this.save(folder, ctx, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(FolderObject fo, Context ctx, Session session) {
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)session, (Connection)writecon, (Connection)writecon);
            oxma.updateFolder(fo, false, false, System.currentTimeMillis());
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)ctx, (Connection)writecon);
            }
        }
    }

    public void unsharePrivateFolder(Session session, Context ctx) {
        FolderObject fo = this.getStandardFolderObject(session.getUserId(), ctx);
        this.unsharePrivateFolder(session, ctx, fo);
    }

    public void unsharePrivateFolder(Session session, Context ctx, FolderObject folder) {
        ArrayList permissions = new ArrayList(folder.getPermissions());
        ArrayList<OCLPermission> newPermissions = new ArrayList<OCLPermission>();
        int userId = session.getUserId();
        int size = permissions.size();
        for (int i = 0; i < size; ++i) {
            OCLPermission permission = (OCLPermission)permissions.get(i);
            if (permission.getEntity() != userId) continue;
            newPermissions.add(permission);
        }
        folder.setPermissions(newPermissions);
        this.save(folder, ctx, session);
    }
}

