/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.calendar.itip.HRRStrings;
import com.openexchange.calendar.itip.Messages;
import com.openexchange.calendar.printing.CalendarPrintingStrings;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.i18n.FolderStrings;
import com.openexchange.groupware.i18n.Groups;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.i18n.Notifications;
import com.openexchange.i18n.I18nService;
import com.openexchange.publish.microformats.FormStrings;
import com.openexchange.publish.microformats.MicroformatStrings;
import com.openexchange.server.services.I18nServices;
import com.openexchange.test.I18nTests;
import com.openexchange.unifiedinbox.NameStrings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TranslatedTest {
    private static final Class<?>[] I18N_CLASSES = new Class[]{HRRStrings.class, Messages.class, CalendarPrintingStrings.class, FolderStrings.class, Groups.class, MailStrings.class, Notifications.class, com.openexchange.messaging.facebook.FormStrings.class, com.openexchange.messaging.facebook.NameStrings.class, com.openexchange.messaging.rss.FormStrings.class, com.openexchange.messaging.twitter.FormStrings.class, com.openexchange.publish.online.infostore.FormStrings.class, MicroformatStrings.class, FormStrings.class, com.openexchange.subscribe.crawler.internal.FormStrings.class, com.openexchange.subscribe.facebook.FormStrings.class, com.openexchange.subscribe.linkedin.FormStrings.class, com.openexchange.subscribe.microformats.FormStrings.class, NameStrings.class};
    private final String className;
    private final Locale locale;
    private final String key;
    private static final String[] whiteRegex = new String[]{"Africa/.*", "America/.*", "Antarctica/.*", "Arctic/.*", "Asia/.*", "Atlantic/.*", "Australia/.*", "Brazil/.*", "Canada/.*", "Chile/.*", "Cuba", "Egypt", "Eire", "Europe/.*", "Greenwich", "Hongkong", "Iceland", "Indian/.*", "Iran", "Israel", "Jamaica", "Japan", "Kwajalein", "Libya", "Mexico/.*", "Mideast/.*", "Navajo", "Pacific/.*", "Poland", "Portugal", "Singapore", "Turkey", "US/.*", "UTC", "Zulu"};

    public TranslatedTest(String className, Locale locale, String key) {
        this.className = className;
        this.locale = locale;
        this.key = key;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws InstantiationException, IllegalAccessException {
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        for (Locale locale : I18nTests.LOCALES) {
            for (Class<?> clazz : I18N_CLASSES) {
                Object instance = clazz.newInstance();
                for (Field field : clazz.getFields()) {
                    if (!String.class.isAssignableFrom(field.getType())) continue;
                    String key = (String)field.get(instance);
                    retval.add(new Object[]{clazz.getName(), locale, key});
                }
            }
            ArrayList<String> timeZoneIDs = new ArrayList<String>();
            for (String timeZoneID : TimeZone.getAvailableIDs()) {
                timeZoneIDs.add(timeZoneID);
            }
            TranslatedTest.removeUnwantedZones(timeZoneIDs);
            for (String timeZoneID : timeZoneIDs) {
                retval.add(new Object[]{TimeZone.class.getName(), locale, timeZoneID.replace('_', ' ')});
            }
        }
        return retval;
    }

    @BeforeClass
    public static void startup() throws Exception {
        Init.injectProperty();
        Init.startAndInjectConfigBundle();
        Init.startAndInjectI18NBundle();
    }

    @AfterClass
    public static void shutdown() {
        Init.dropI18NBundle();
        Init.dropConfigBundle();
        Init.dropProperty();
    }

    @Test
    public void testTranslation() {
        I18nService i18nService = I18nServices.getInstance().getService(this.locale);
        Assert.assertNotNull((String)("Can't get i18n service for " + this.locale.toString()), (Object)i18nService);
        boolean isTranslated = i18nService.hasKey(this.key);
        Assert.assertTrue((String)("No translation for key \"" + this.key + "\" of class " + this.className + " into language " + this.locale + "."), (boolean)isTranslated);
        String translation = i18nService.getLocalized(this.key);
        Assert.assertNotNull((String)("Translation for key \"" + this.key + "\" of class " + this.className + " is null."), (Object)translation);
    }

    private static void removeUnwantedZones(List<String> timeZoneIDs) {
        Pattern[] patterns = new Pattern[whiteRegex.length];
        int i = 0;
        for (String regex : whiteRegex) {
            patterns[i++] = Pattern.compile(regex);
        }
        Iterator<String> iter = timeZoneIDs.iterator();
        while (iter.hasNext()) {
            Pattern pattern;
            String timeZoneID = iter.next();
            boolean isWhiteListed = false;
            Pattern[] arr$ = patterns;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(isWhiteListed = (pattern = arr$[i$]).matcher(timeZoneID).matches()); ++i$) {
            }
            if (isWhiteListed) continue;
            iter.remove();
        }
    }
}

