/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tx.AbstractActionTest;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractInfostoreActionTest
extends AbstractActionTest {
    private User user;
    private Context ctx;
    private final List<DocumentMetadata> infoitems = new ArrayList<DocumentMetadata>();
    private final List<DocumentMetadata> updatedInfoitems = new ArrayList<DocumentMetadata>();
    private InfostoreQueryCatalog queryCatalog;
    private DBProvider provider;
    private InfostoreFacade infostore;

    public void setUp() throws Exception {
        Init.startServer();
        this.provider = new DBPoolProvider();
        this.queryCatalog = new InfostoreQueryCatalog();
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        int userId = tools.resolveUser(userName, this.ctx);
        this.ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
        this.user = UserStorage.getInstance().getUser(userId, this.ctx);
        this.initDocMeta();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
    }

    protected User getUser() {
        return this.user;
    }

    protected Context getContext() {
        return this.ctx;
    }

    protected List<DocumentMetadata> getDocuments() {
        return this.infoitems;
    }

    protected List<DocumentMetadata> getUpdatedDocuments() {
        return this.updatedInfoitems;
    }

    protected InfostoreQueryCatalog getQueryCatalog() {
        return this.queryCatalog;
    }

    protected DBProvider getProvider() {
        return this.provider;
    }

    protected InfostoreFacade getInfostore() {
        return this.infostore;
    }

    protected UserConfiguration getUserConfiguration() {
        return null;
    }

    protected void assertNoResult(String sql, Object ... args) throws OXException, SQLException {
        AbstractInfostoreActionTest.assertFalse((boolean)this.hasResult(sql, args));
    }

    protected void assertResult(String sql, Object ... args) throws OXException, SQLException {
        AbstractInfostoreActionTest.assertTrue((boolean)this.hasResult(sql, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasResult(String sql, Object[] args) throws OXException, SQLException {
        boolean bl;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getProvider().getReadConnection(this.getContext());
            stmt = readCon.prepareStatement(sql);
            int i = 1;
            for (Object arg : args) {
                stmt.setObject(i++, arg);
            }
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            this.getProvider().releaseReadConnection(this.getContext(), readCon);
            throw throwable;
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        this.getProvider().releaseReadConnection(this.getContext(), readCon);
        return bl;
    }

    private void initDocMeta() {
        DocumentMetadataImpl m = new DocumentMetadataImpl();
        m.setCategories("cat1, cat2, cat3");
        m.setColorLabel(12);
        m.setCreatedBy(12);
        m.setCreationDate(new Date());
        m.setDescription("desc");
        m.setFileMD5Sum("3j4klhl");
        m.setFileMIMEType("text/plain");
        m.setFileName("test.txt");
        m.setFileSize(123332L);
        m.setFolderId(12L);
        m.setId(101024);
        m.setLastModified(new Date());
        m.setModifiedBy(23);
        m.setTitle("title");
        m.setURL("http://gnirz.com");
        m.setVersion(2);
        m.setVersionComment("vc");
        this.infoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(102048);
        this.infoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(104096);
        this.infoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(108192);
        this.infoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(101024);
        m.setColorLabel(42);
        m.setFileName("updated.txt");
        this.updatedInfoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(102048);
        this.updatedInfoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(104096);
        this.updatedInfoitems.add((DocumentMetadata)m);
        m = new DocumentMetadataImpl((DocumentMetadata)m);
        m.setId(108192);
        this.updatedInfoitems.add((DocumentMetadata)m);
    }
}

