/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.event.CommonEvent;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.tools.events.TestEventAdmin;

public class Bug5557Test
extends CalendarSqlTest {
    public void testUpdateToAppointmentShouldThrowEventIncludingPrivateFolderIds() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.participant1, this.participant2, this.participant3);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        TestEventAdmin.getInstance().clearEvents();
        CalendarDataObject update = this.appointments.createIdentifyingCopy(appointment);
        update.setTitle("Title update 5557");
        this.appointments.save(appointment);
        CommonEvent event = TestEventAdmin.getInstance().getNewest();
        Appointment appointmentFromEvent = (Appointment)event.getActionObj();
        Bug5557Test.assertNotNull((Object)appointmentFromEvent.getUsers());
        for (UserParticipant userParticipant : appointmentFromEvent.getUsers()) {
            int participantsStandardCalendar = this.folders.getStandardFolder(userParticipant.getIdentifier(), this.ctx);
            Bug5557Test.assertEquals((int)participantsStandardCalendar, (int)userParticipant.getPersonalFolderId());
        }
    }
}

