/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.FolderObject;

public class Bug14625Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;
    private FolderObject folder;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.folders.createPublicFolderFor(this.session, this.ctx, "Bug 14625 Test Folder", 2, this.userId, this.secondUserId);
        this.cleanFolders.add(this.folder);
        this.appointment = this.appointments.buildAppointmentWithUserParticipants(this.secondUser);
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setTitle("Bug 14625 Test Appointment");
        this.appointment.removeUsers();
        this.appointments.save(this.appointment);
        this.clean.add(this.appointment);
    }

    public void testBug14625() throws Exception {
        CalendarDataObject loadAppointment = this.appointments.load(this.appointment.getObjectID(), this.folder.getObjectID());
        Bug14625Test.assertEquals((String)"Wrong amount of Participants.", (int)1, (int)loadAppointment.getParticipants().length);
        Bug14625Test.assertEquals((String)"Wrong participant.", (int)this.secondUserId, (int)loadAppointment.getParticipants()[0].getIdentifier());
        Bug14625Test.assertEquals((String)"Wrong amount of Users.", (int)1, (int)loadAppointment.getUsers().length);
        Bug14625Test.assertEquals((String)"Wrong user.", (int)this.secondUserId, (int)loadAppointment.getUsers()[0].getIdentifier());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

