/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.actions.AbstractAttachmentActionTest;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.attach.impl.CreateAttachmentAction;
import com.openexchange.groupware.attach.impl.UpdateAttachmentAction;
import com.openexchange.tx.UndoableAction;
import java.util.Arrays;

public class UpdateAttachmentsActionTest
extends AbstractAttachmentActionTest {
    private final CreateAttachmentAction createAction = new CreateAttachmentAction();
    private AttachmentMetadata update;
    private AttachmentMetadata original;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createAction.setAttachments(this.getAttachments());
        this.createAction.setQueryCatalog(this.getQueryCatalog());
        this.createAction.setProvider(this.getProvider());
        this.createAction.setContext(this.getContext());
        this.createAction.perform();
        this.original = this.getAttachments().get(0);
        this.update = new AttachmentImpl(this.original);
        this.update.setFilename("otherfile.txt");
    }

    @Override
    public void tearDown() throws Exception {
        this.createAction.undo();
        super.tearDown();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        UpdateAttachmentAction updateAction = new UpdateAttachmentAction();
        updateAction.setAttachments(Arrays.asList(this.update));
        updateAction.setOldAttachments(Arrays.asList(this.original));
        updateAction.setQueryCatalog(this.getQueryCatalog());
        updateAction.setProvider(this.getProvider());
        updateAction.setContext(this.getContext());
        return updateAction;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        AttachmentMetadata loaded = this.getAttachmentBase().getAttachment(this.getSession(), this.update.getFolderId(), this.update.getAttachedId(), this.update.getModuleId(), this.update.getId(), this.getContext(), this.getUser(), null);
        UpdateAttachmentsActionTest.assertEquals(this.update, loaded);
    }

    @Override
    protected void verifyUndone() throws Exception {
        AttachmentMetadata loaded = this.getAttachmentBase().getAttachment(this.getSession(), this.update.getFolderId(), this.update.getAttachedId(), this.update.getModuleId(), this.update.getId(), this.getContext(), this.getUser(), null);
        UpdateAttachmentsActionTest.assertEquals(this.original, loaded);
    }
}

