/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.ical;

import com.openexchange.dav.caldav.ical.ICalUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleICal {
    private static final String CRLF = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component parse(String iCal) throws IOException, SimpleICalException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(ICalUtils.unfold(iCal)));
            String line = reader.readLine();
            if (null == line || !line.startsWith("BEGIN:VCALENDAR")) {
                throw new SimpleICalException("VCALENDAR component expected");
            }
            Component component = new Component("VCALENDAR", reader);
            return component;
        }
        finally {
            reader.close();
        }
    }

    public static final class SimpleICalException
    extends Exception {
        private static final long serialVersionUID = -24367328086610189L;

        public SimpleICalException(String msg) {
            super(msg);
        }
    }

    public static final class Property {
        private String name;
        private String value;
        private Map<String, String> attributes;

        public Property(String line) throws SimpleICalException {
            this.attributes = new HashMap<String, String>();
            this.parse(line);
        }

        public Property(String name, String value, Map<String, String> attributes) {
            this.name = name;
            this.value = value;
            this.attributes = attributes;
        }

        private void parse(String line) throws SimpleICalException {
            int index = line.indexOf(58);
            if (0 > index) {
                throw new SimpleICalException("No ':' character found in " + line);
            }
            this.value = line.substring(1 + index).trim();
            String nameAndAttributes = line.substring(0, index);
            if (0 > (index = nameAndAttributes.indexOf(59))) {
                this.name = nameAndAttributes.toUpperCase();
            } else {
                this.name = nameAndAttributes.substring(0, index).toUpperCase();
                StringBuilder attributeNameBuilder = new StringBuilder();
                StringBuilder attributeValueBuilder = new StringBuilder();
                boolean inQuote = false;
                boolean inAttributeName = true;
                for (int i = index; i < nameAndAttributes.length(); ++i) {
                    char c = nameAndAttributes.charAt(i);
                    if (';' == c && !inQuote) {
                        if (0 >= attributeNameBuilder.length()) continue;
                        this.attributes.put(attributeNameBuilder.toString(), attributeValueBuilder.toString());
                        attributeNameBuilder.setLength(0);
                        attributeValueBuilder.setLength(0);
                        inAttributeName = true;
                        continue;
                    }
                    if ('=' == c && !inQuote) {
                        inAttributeName = false;
                        continue;
                    }
                    if (',' == c && !inQuote) {
                        throw new SimpleICalException("Unquoted comma in attribute value: " + nameAndAttributes);
                    }
                    if ('\"' == c) {
                        inQuote = false == inQuote;
                        continue;
                    }
                    if (inAttributeName) {
                        attributeNameBuilder.append(c);
                        continue;
                    }
                    attributeValueBuilder.append(c);
                }
                if (0 < attributeNameBuilder.length()) {
                    this.attributes.put(attributeNameBuilder.toString(), attributeValueBuilder.toString());
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getAttribute(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                stringBuilder.append(";").append(entry.getKey()).append("=");
                if (0 < entry.getValue().indexOf(44)) {
                    stringBuilder.append('\"').append(entry.getValue()).append('\"');
                    continue;
                }
                stringBuilder.append(entry.getValue());
            }
            stringBuilder.append(":").append(this.value);
            return stringBuilder.toString();
        }
    }

    public static final class Component {
        private final String name;
        private final List<Property> properties;
        private final List<Component> components;

        public Component(String name, BufferedReader reader) throws SimpleICalException, IOException {
            this(name);
            this.parse(reader);
        }

        public Component(String name) {
            this.name = name;
            this.properties = new ArrayList<Property>();
            this.components = new ArrayList<Component>();
        }

        public String getUID() {
            return this.getPropertyValue("UID");
        }

        public String getSummary() {
            return this.getPropertyValue("SUMMARY");
        }

        public void setSummary(String summary) throws ParseException {
            this.setProperty("SUMMARY", summary);
        }

        public Date getRecurrenceID() throws ParseException {
            return ICalUtils.parseDate(this.getProperty("RECURRENCE-ID"));
        }

        public Date getDTStart() throws ParseException {
            return ICalUtils.parseDate(this.getProperty("DTSTART"));
        }

        public void setDTStart(Date start) throws ParseException {
            this.setProperty("DTSTART", ICalUtils.formatAsUTC(start));
        }

        public Date getDTEnd() throws ParseException {
            return ICalUtils.parseDate(this.getProperty("DTEND"));
        }

        public void setDTEnd(Date start) throws ParseException {
            this.setProperty("DTEND", ICalUtils.formatAsUTC(start));
        }

        public String getLocation() {
            return this.getPropertyValue("LOCATION");
        }

        public String getTransp() {
            return this.getPropertyValue("TRANSP");
        }

        public void setTransp(String transp) {
            this.setProperty("TRANSP", transp);
        }

        public List<Component> getComponents() {
            return this.components;
        }

        public List<Component> getComponents(String type) {
            ArrayList<Component> filteredComponents = new ArrayList<Component>();
            for (Component component : this.components) {
                if (!type.equals(component.getName())) continue;
                filteredComponents.add(component);
            }
            return filteredComponents;
        }

        private void parse(BufferedReader reader) throws SimpleICalException, IOException {
            String line = null;
            while (null != (line = reader.readLine()) && !line.startsWith("END:" + this.name)) {
                if (line.startsWith("BEGIN:")) {
                    String name = line.substring(6).trim();
                    this.components.add(new Component(name, reader));
                    continue;
                }
                this.properties.add(new Property(line));
            }
        }

        public String getName() {
            return this.name;
        }

        public Property getProperty(String name) {
            for (Property property : this.properties) {
                if (!name.equals(property.name)) continue;
                return property;
            }
            return null;
        }

        public void setProperty(String name, String value, Map<String, String> attributes) {
            for (Property property : this.properties) {
                if (!name.equals(property.name)) continue;
                property.value = value;
                property.attributes = attributes;
                return;
            }
            this.properties.add(new Property(name, value, attributes));
        }

        public void setProperty(String name, String value) {
            this.setProperty(name, value, new HashMap<String, String>());
        }

        public List<Property> getProperties(String name) {
            ArrayList<Property> properties = new ArrayList<Property>();
            for (Property property : this.properties) {
                if (!name.equals(property.name)) continue;
                properties.add(property);
            }
            return properties;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public String getPropertyValue(String propertyName) {
            Property property = this.getProperty(propertyName);
            return null != property ? property.value : null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("BEGIN:").append(this.name).append(SimpleICal.CRLF);
            for (Property property : this.properties) {
                stringBuilder.append(property).append(SimpleICal.CRLF);
            }
            for (Component component : this.components) {
                stringBuilder.append(component).append(SimpleICal.CRLF);
            }
            stringBuilder.append("END:").append(this.name);
            return stringBuilder.toString();
        }
    }
}

