/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Bug24682Test
extends CalDAVTest {
    private CalendarTestManager[] managers;
    CalendarTestManager userA;
    CalendarTestManager userB;
    CalendarTestManager userC;
    CalendarTestManager userD;

    public Bug24682Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.managers = new CalendarTestManager[3];
        this.managers[0] = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.managers[1] = new CalendarTestManager(new AJAXClient(AJAXClient.User.User3));
        this.managers[2] = new CalendarTestManager(new AJAXClient(AJAXClient.User.User4));
        for (CalendarTestManager manager : this.managers) {
            manager.setFailOnError(true);
        }
        this.userA = this.getManager();
        this.userB = this.managers[0];
        this.userC = this.managers[1];
        this.userD = this.managers[2];
        FolderTools.shareFolder(this.userC.getClient(), EnumAPI.OX_NEW, this.userC.getPrivateFolder(), this.userA.getClient().getValues().getUserId(), 4, 4, 4, 4);
        FolderTools.shareFolder(this.userC.getClient(), EnumAPI.OX_NEW, this.userC.getPrivateFolder(), this.userB.getClient().getValues().getUserId(), 4, 4, 4, 4);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.managers) {
            for (CalendarTestManager manager : this.managers) {
                if (null == manager) continue;
                manager.cleanUp();
            }
        }
        if (null != this.userC && null != this.userC.getClient()) {
            if (null != this.userA && null != this.userA.getClient()) {
                FolderTools.unshareFolder(this.userC.getClient(), EnumAPI.OX_NEW, this.userC.getPrivateFolder(), this.userA.getClient().getValues().getUserId());
            }
            if (null != this.userB && null != this.userB.getClient()) {
                FolderTools.unshareFolder(this.userC.getClient(), EnumAPI.OX_NEW, this.userC.getPrivateFolder(), this.userB.getClient().getValues().getUserId());
            }
        }
        if (null != this.managers) {
            for (CalendarTestManager manager : this.managers) {
                if (null == manager || null == manager.getClient()) continue;
                manager.getClient().logout();
            }
        }
        super.tearDown();
    }

    public void testGetChangeExceptionsInSharedFolder() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken(String.valueOf(this.userC.getPrivateFolder())));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("Last week at 2pm", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setParentFolderID(this.userC.getPrivateFolder());
        appointment.setUid(Bug24682Test.randomUID());
        appointment.setTitle(((Object)((Object)this)).getClass().getName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setRecurrenceType(2);
        appointment.setInterval(1);
        appointment.addParticipant((Participant)new UserParticipant(this.userD.getClient().getValues().getUserId()));
        appointment.setDays(2 ^ calendar.get(7) - 1);
        appointment = this.userB.insert(appointment);
        Map<String, String> eTags = super.syncCollection(syncToken, String.valueOf(this.userC.getPrivateFolder())).getETagsStatusOK();
        Bug24682Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(String.valueOf(this.userC.getPrivateFolder()), eTags.keySet());
        ICalResource iCalResource = Bug24682Test.assertContains(appointment.getUid(), calendarData);
        Bug24682Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug24682Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)iCalResource.getVEvent().getSummary());
        Appointment exception = this.userB.createIdentifyingCopy(appointment);
        calendar.add(6, 7);
        exception.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        exception.setEndDate(calendar.getTime());
        exception.setTitle(appointment.getTitle() + "_edit");
        exception.setRecurrencePosition(2);
        this.userB.update(exception);
        eTags = super.syncCollection(syncToken, String.valueOf(this.userC.getPrivateFolder())).getETagsStatusOK();
        Bug24682Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(String.valueOf(this.userC.getPrivateFolder()), eTags.keySet());
        iCalResource = Bug24682Test.assertContains(appointment.getUid(), calendarData);
        Bug24682Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        SimpleICal.Component vEventException = null;
        for (SimpleICal.Component vEvent : iCalResource.getVEvents()) {
            Date recurrenceID = vEvent.getRecurrenceID();
            if (null != recurrenceID) {
                Bug24682Test.assertEquals((String)"SUMMARY wrong", (String)exception.getTitle(), (String)vEvent.getSummary());
                vEventException = vEvent;
                continue;
            }
            Bug24682Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)vEvent.getSummary());
        }
        Bug24682Test.assertNotNull((String)"No exception found on client", vEventException);
    }
}

