/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskSearchJSONWriter {
    private TaskSearchJSONWriter() {
    }

    public static JSONObject write(TaskSearchObject search) throws OXException, JSONException {
        Date[] range = search.getRange();
        if (range != null && range.length != 2) {
            throw TaskExceptionCode.WRONG_DATE_RANGE.create(new Object[]{range.length});
        }
        JSONObject json = new JSONObject();
        if (-1 != search.getFolder()) {
            json.put("folder", search.getFolder());
        }
        if (TaskSearchObject.NO_RANGE != range) {
            json.put("start", (Object)range[0]);
            json.put("end", (Object)range[1]);
        }
        if (TaskSearchObject.NO_PATTERN != search.getPattern()) {
            json.put("pattern", (Object)search.getPattern());
        }
        if (TaskSearchObject.NO_TITLE != search.getTitle()) {
            json.put("title", (Object)search.getTitle());
        }
        if (-1 != search.getPriority()) {
            json.put("priority", search.getPriority());
        }
        if (search.isSearchInNote()) {
            json.put("searchinnote", true);
        }
        if (-1 != search.getStatus()) {
            json.put("status", search.getStatus());
        }
        if (TaskSearchObject.NO_CATEGORIES != search.getCatgories()) {
            json.put("categories", (Object)search.getCatgories());
        }
        if (search.isSubfolderSearch()) {
            json.put("subfoldersearch", search.isSubfolderSearch());
        }
        return json;
    }
}

