/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class TaskAttachmentTests
extends AbstractAJAXSession {
    private int folderId;
    private TimeZone tz;
    private Task task;
    private int attachmentId;
    private Date creationDate;

    public TaskAttachmentTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Test task for testing attachments");
        this.client.execute(new InsertRequest(this.task, this.tz)).fillTask(this.task);
        this.attachmentId = this.client.execute(new AttachRequest((CommonObject)this.task, "test.txt", new ByteArrayInputStream("Test".getBytes()), "text/plain")).getId();
        com.openexchange.ajax.attach.actions.GetResponse response = this.client.execute(new com.openexchange.ajax.attach.actions.GetRequest((CommonObject)this.task, this.attachmentId));
        long timestamp = response.getAttachment().getCreationDate().getTime();
        this.creationDate = new Date(timestamp - (long)this.tz.getOffset(timestamp));
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testLastModifiedOfNewestAttachmentWithGet() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(this.task.getParentFolderID(), this.task.getObjectID()));
        this.task.setLastModified(response.getTimestamp());
        Task test = response.getTask(this.tz);
        TaskAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithAll() throws Throwable {
        CommonAllResponse response = this.client.execute(new AllRequest(this.task.getParentFolderID(), new int[]{1, 105}, 1, Order.ASCENDING));
        this.task.setLastModified(response.getTimestamp());
        Task test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.task.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Task();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created task with an attachment.");
        }
        TaskAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithList() throws Throwable {
        CommonListResponse response = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}}), new int[]{1, 105}));
        this.task.setLastModified(response.getTimestamp());
        Task test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.task.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Task();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created task with an attachment.");
        }
        TaskAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }
}

