/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.task.AbstractTaskTestForAJAXClient;
import com.openexchange.ajax.task.actions.ConfirmWithTaskInBodyRequest;
import com.openexchange.ajax.task.actions.ConfirmWithTaskInParametersRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TestTask;
import com.openexchange.test.TaskTestManager;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ConfirmTest
extends AbstractTaskTestForAJAXClient {
    private TaskTestManager manager;
    private int userId;
    private TestTask task;

    public ConfirmTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new TaskTestManager(this.getClient());
        this.task = this.getNewTask(this.getName());
        this.userId = this.getClient().getValues().getUserId();
        this.task.addParticipant((Participant)new UserParticipant(this.userId));
        this.manager.insertTaskOnServer(this.task);
    }

    @Override
    public void tearDown() throws Exception {
        this.task.setLastModified(new Date(Long.MAX_VALUE));
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testConfirmWithTaskInParameters() throws OXException, IOException, SAXException, JSONException {
        ConfirmWithTaskInParametersRequest request = new ConfirmWithTaskInParametersRequest(this.task, 1, "Confirmanize!");
        this.getClient().execute(request);
        this.checkTaskOnServer(1, "Confirmanize!");
    }

    public void testConfirmWithTaskInBody() throws OXException, IOException, SAXException, JSONException {
        ConfirmWithTaskInBodyRequest request = new ConfirmWithTaskInBodyRequest(this.task, 1, "Confirmanize!");
        this.getClient().execute(request);
        this.checkTaskOnServer(1, "Confirmanize!");
    }

    private void checkTaskOnServer(int confirmmation, String message) {
        Task reloaded = this.manager.getTaskFromServer(this.task);
        boolean found = false;
        for (UserParticipant user : reloaded.getUsers()) {
            if (user.getIdentifier() != this.userId) continue;
            ConfirmTest.assertEquals((int)confirmmation, (int)user.getConfirm());
            ConfirmTest.assertEquals((String)message, (String)user.getConfirmMessage());
            found = true;
        }
        ConfirmTest.assertTrue((boolean)found);
    }
}

