/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;

public class Bug15937Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task;
    private TimeZone timeZone;

    public Bug15937Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 15937");
        this.task.setNumberOfAttachments(42);
        InsertRequest request = new InsertRequest(this.task, this.timeZone);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testNumberOfAttachments() throws Throwable {
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        Task testTask = response.getTask(this.timeZone);
        Bug15937Test.assertTrue((String)"Number of attachments should be send.", (boolean)testTask.containsNumberOfAttachments());
        Bug15937Test.assertEquals((String)"Number of attachments must be zero.", (int)0, (int)testTask.getNumberOfAttachments());
    }
}

