/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.roundtrip.pubsub;

import com.openexchange.ajax.publish.tests.AbstractPubSubTest;
import com.openexchange.ajax.publish.tests.PublicationTestManager;
import com.openexchange.ajax.subscribe.test.SubscriptionTestManager;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;

public class AbstractPubSubRoundtripTest
extends AbstractPubSubTest {
    private SubscriptionTestManager subMgr;
    private PublicationTestManager pubMgr;

    public void setSubscribeManager(SubscriptionTestManager subMgr) {
        this.subMgr = subMgr;
    }

    public SubscriptionTestManager getSubscribeManager() {
        return this.subMgr;
    }

    public void setPublishManager(PublicationTestManager pubMgr) {
        this.pubMgr = pubMgr;
    }

    public PublicationTestManager getPublishManager() {
        return this.pubMgr;
    }

    public AbstractPubSubRoundtripTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSubscribeManager(new SubscriptionTestManager(this.getClient()));
        this.setPublishManager(new PublicationTestManager(this.getClient()));
    }

    @Override
    protected void tearDown() throws Exception {
        this.getSubscribeManager().cleanUp();
        this.getPublishManager().cleanUp();
        super.tearDown();
    }

    protected void assertNoDataMessedUpMinimumRequirements(Contact expected, Contact actual) {
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getSurName(), (String)actual.getSurName());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getGivenName(), (String)actual.getGivenName());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getCompany(), (String)actual.getCompany());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getEmail1(), (String)actual.getEmail1());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getDisplayName(), (String)actual.getDisplayName());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getPosition(), (String)actual.getPosition());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getTitle(), (String)actual.getTitle());
        AbstractPubSubRoundtripTest.assertEquals((String)expected.getSurName(), (String)actual.getSurName());
    }

    protected void assertNoDataMessedUpMaximumRequirements(Contact expected, Contact actual) {
        for (ContactField fieldEnum : ContactField.values()) {
            int field = fieldEnum.getNumber();
            AbstractPubSubRoundtripTest.assertEquals((String)("Expecting field " + fieldEnum + " to match"), (Object)expected.get(field), (Object)actual.get(field));
        }
    }
}

