/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.publish.actions.DeletePublicationRequest;
import com.openexchange.ajax.publish.actions.GetPublicationRequest;
import com.openexchange.ajax.publish.actions.GetPublicationResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.publish.Publication;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class DeletePublicationTest
extends AbstractPublicationTest {
    public DeletePublicationTest(String name) {
        super(name);
    }

    public void testDeletingAFolderDeletesThePublication() throws OXException, IOException, SAXException, JSONException, InterruptedException {
        Contact contact = this.createDefaultContactFolderWithOneContact();
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication("contacts", String.valueOf(contact.getParentFolderID()), discovery);
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        AJAXClient myClient = this.getClient();
        NewPublicationResponse newResp = myClient.execute(newReq);
        DeletePublicationTest.assertFalse((String)"Precondition: Should be able to create a publication", (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        this.getFolderManager().deleteFolderOnServer(contact.getParentFolderID(), new Date(Long.MAX_VALUE));
        Thread.sleep(1000L);
        GetPublicationRequest getReq = new GetPublicationRequest(expected.getId());
        GetPublicationResponse getResp = myClient.execute(getReq);
        DeletePublicationTest.assertTrue((String)"Reading a publication of a deleted folder should not work", (boolean)getResp.hasError());
    }

    public void testDeletionOfPublicationShouldWork() throws OXException, IOException, SAXException, JSONException {
        Contact contact = this.createDefaultContactFolderWithOneContact();
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication("contacts", String.valueOf(contact.getParentFolderID()), discovery);
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        AJAXClient myClient = this.getClient();
        NewPublicationResponse newResp = myClient.execute(newReq);
        expected.setId(newResp.getId());
        DeletePublicationRequest delReq = new DeletePublicationRequest(expected.getId());
        GetPublicationResponse delResp = myClient.execute(delReq);
        DeletePublicationTest.assertFalse((String)"Deletion should produce no errors", (boolean)delResp.hasError());
        GetPublicationRequest getReq = new GetPublicationRequest(expected.getId());
        GetPublicationResponse getResp = myClient.execute(getReq);
        DeletePublicationTest.assertTrue((String)"Reading deleted publication should produce exception", (boolean)getResp.hasError());
    }

    public void testDeletionOfNonExistingPublicationShouldFail() throws OXException, IOException, SAXException, JSONException {
        this.pubMgr.setFailOnError(false);
        this.pubMgr.deleteAction(Arrays.asList(Integer.MAX_VALUE));
        DeletePublicationTest.assertTrue((String)"Deletion of non-existing publication should produce errors", (boolean)this.pubMgr.getLastResponse().hasError());
    }
}

