/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractUploadParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mail.actions.SendResponse;
import java.io.InputStream;
import java.util.ArrayList;

public class SendRequest
implements AJAXRequest<SendResponse> {
    public static final String MAIL_URL = "/ajax/mail";
    private final String mailStr;
    private final InputStream upload;
    private String recipientTo;

    public SendRequest(String mailStr) {
        this(mailStr, null);
    }

    public SendRequest(String mailStr, InputStream upload) {
        this.mailStr = mailStr;
        this.upload = upload;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.UPLOAD;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>(4);
        params.add(new AJAXRequest.Parameter("action", "new"));
        params.add(new AJAXRequest.FieldParameter("json_0", this.mailStr));
        if (null != this.upload) {
            params.add(new AJAXRequest.FileParameter("file_0", "text.txt", this.upload, "text/plain; charset=us-ascii"));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    @Override
    public String getServletPath() {
        return MAIL_URL;
    }

    public SendParser getParser() {
        return new SendParser(true);
    }

    private static final class SendParser
    extends AbstractUploadParser<SendResponse> {
        public SendParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected SendResponse createResponse(Response response) {
            return new SendResponse(response);
        }
    }
}

