/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class UpdatesTest
extends InfostoreAJAXTest {
    public UpdatesTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1});
        UpdatesTest.assertNoError(res);
        long ts = res.getTimestamp().getTime() + 2L;
        this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), ts, this.m("title", "test knowledge updated"));
        res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{700, 706}, ts);
        UpdatesTest.assertNoError(res);
        JSONArray modAndDel = (JSONArray)res.getData();
        UpdatesTest.assertEquals((int)1, (int)modAndDel.length());
        JSONArray fields = modAndDel.getJSONArray(0);
        UpdatesTest.assertEquals((String)"test knowledge updated", (String)fields.getString(0));
        UpdatesTest.assertEquals((String)"test knowledge description", (String)fields.getString(1));
        HashSet ids = new HashSet(this.clean);
        ts = res.getTimestamp().getTime();
        this.removeAll();
        res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{700, 706}, ts);
        UpdatesTest.assertNoError(res);
        modAndDel = (JSONArray)res.getData();
        UpdatesTest.assertEquals((int)2, (int)modAndDel.length());
        for (int i = 0; i < 2; ++i) {
            UpdatesTest.assertTrue((boolean)ids.remove(modAndDel.getInt(i)));
        }
        UpdatesTest.assertTrue((boolean)ids.isEmpty());
    }

    public void testRemovedVersionForcesUpdate() throws Exception {
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1});
        UpdatesTest.assertNoError(res);
        long ts = res.getTimestamp().getTime() + 2L;
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 1"), upload, "text/plain");
        UpdatesTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 2"), upload, "text/plain");
        UpdatesTest.assertNoError(res);
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("version_comment", "Comment 3"), upload, "text/plain");
        UpdatesTest.assertNoError(res);
        int[] nd = this.detach(this.getWebConversation(), this.getHostName(), this.sessionId, ts, (Integer)this.clean.get(0), new int[]{3});
        UpdatesTest.assertEquals((int)0, (int)nd.length);
        res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{700, 706}, ts);
        UpdatesTest.assertNoError(res);
        JSONArray modAndDel = (JSONArray)res.getData();
        UpdatesTest.assertEquals((int)1, (int)modAndDel.length());
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolderTest(folderId);
        }
    }

    public void virtualFolderTest(int folderId) throws Exception {
        Response res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, folderId, new int[]{1}, 0L);
        UpdatesTest.assertNoError(res);
        JSONArray modAndDel = (JSONArray)res.getData();
        UpdatesTest.assertEquals((int)0, (int)modAndDel.length());
    }

    public void testLastModifiedUTC() throws JSONException, IOException, SAXException {
        Response res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{6}, 0L);
        UpdatesTest.assertNoError(res);
        JSONArray modAndDel = (JSONArray)res.getData();
        UpdatesTest.assertTrue((modAndDel.length() > 0 ? 1 : 0) != 0);
        JSONArray fields = modAndDel.getJSONArray(0);
        UpdatesTest.assertNotNull((Object)fields.optLong(0));
    }

    public void testNumberOfVersions() throws JSONException, IOException, SAXException {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m("description", "New description"), upload, "text/plain");
        UpdatesTest.assertNoError(res);
        res = this.updates(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1, 711}, 0L);
        JSONArray rows = (JSONArray)res.getData();
        boolean found = false;
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = rows.getJSONArray(i);
            int id = row.getInt(0);
            int numberOfVersions = row.getInt(1);
            if (id != (Integer)this.clean.get(0)) continue;
            UpdatesTest.assertEquals((int)1, (int)numberOfVersions);
            found = true;
        }
        UpdatesTest.assertTrue((boolean)found);
    }
}

