/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.UserTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.ajax.resource.actions.ResourceDeleteRequest;
import com.openexchange.ajax.resource.actions.ResourceNewRequest;
import com.openexchange.ajax.resource.actions.ResourceNewResponse;
import com.openexchange.ajax.user.UserImpl4Test;
import com.openexchange.ajax.user.actions.SearchRequest;
import com.openexchange.ajax.user.actions.SearchResponse;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.resource.Resource;

public final class Bug11868Test
extends AbstractAJAXSession {
    private static final String ICAL = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:OPEN-XCHANGE\nBEGIN:VEVENT\nDTSTAMP:20080807T103300Z\nSUMMARY:Hosting Call\nDESCRIPTION:Recreated due to several reasons\nDTSTART:20080225T130000Z\nDTEND:20080225T140000Z\nCLASS:PUBLIC\nLOCATION:TelCo1\nTRANSP:OPAQUE\nATTENDEE:MAILTO:@email1@\nATTENDEE:MAILTO:@email2@\nATTENDEE:MAILTO:@email3@\nRESOURCES:@resource1@\nRRULE:FREQ=WEEKLY;INTERVAL=1;BYDAY=MO\nEND:VEVENT\nEND:VCALENDAR\n";

    public Bug11868Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWholeDayAppointment() throws Throwable {
        AJAXClient client = this.getClient();
        ContactSearchObject search = new ContactSearchObject();
        search.setPattern("*");
        search.addFolder(6);
        SearchRequest request = new SearchRequest(search, UserTest.CONTACT_FIELDS);
        SearchResponse response = Executor.execute(client, request);
        UserImpl4Test[] user = response.getUser();
        String ical = ICAL.replace("@email1@", user[0].getMail()).replace("@email2@", user[1].getMail()).replace("@email3@", user[2].getMail());
        Resource resource = new Resource();
        long different = System.currentTimeMillis();
        resource.setDisplayName("Bug 11868 test resource" + different);
        resource.setSimpleName("Bug 11868 test resource " + different);
        resource.setMail("bug11868testresource" + different + "@example.org");
        ResourceNewResponse response2 = Executor.execute(client, new ResourceNewRequest(resource));
        resource.setIdentifier(response2.getID());
        resource.setLastModified(response2.getTimestamp());
        ical = ical.replace("@resource1@", resource.getDisplayName());
        int folderId = client.getValues().getPrivateAppointmentFolder();
        ICalImportResponse iResponse = Executor.execute(client, new ICalImportRequest(folderId, ical));
        ImportResult result = iResponse.getImports()[0];
        int objectId = Integer.parseInt(result.getObjectId());
        try {
            GetResponse gResponse = Executor.execute(client, new GetRequest(folderId, objectId));
            Bug11868Test.assertFalse((boolean)gResponse.hasError());
        }
        finally {
            Executor.execute(client, new DeleteRequest(objectId, folderId, result.getDate()));
            Executor.execute(client, new ResourceDeleteRequest(resource));
        }
    }
}

