/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.importexport.ContactTestData;
import com.openexchange.importexport.formats.Format;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import org.json.JSONException;
import org.xml.sax.SAXException;

public abstract class AbstractImportExportServletTest
extends AbstractAJAXTest {
    public String FOLDER_NAME = "csv-contact-roundtrip-ajax-test";
    public String IMPORTED_CSV = ContactTestData.IMPORT_MULTIPLE;
    public String EXPORT_SERVLET = "export";
    public String IMPORT_SERVLET = "import";
    public String IMPORT_VCARD = "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;;Meinerzhagen;NRW;58540;DE\nTEL;TYPE=home,voice:+49 2358 7192\nEMAIL:tobias.prinz@open-xchange.com\nORG:- deactivated -\nREV:20061204T160750.018Z\nURL:www.tobias-prinz.de\nUID:80@ox6.netline.de\nEND:VCARD\n";
    public String[] IMPORT_VCARD_AWAITED_ELEMENTS = "PRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nBDAY:19810501\nADR;TYPE=work:;;;Meinerzhagen;NRW;58540;DE\nTEL;TYPE=home,voice:+49 2358 7192\nEMAIL:tobias.prinz@open-xchange.com".split("\n");

    public AbstractImportExportServletTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected int getUserId_FIXME() throws MalformedURLException, OXException, IOException, SAXException, JSONException, OXException {
        FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        return folderObj.getCreatedBy();
    }

    public String getUrl(String servlet, int folderId, Format format) throws IOException, JSONException, OXException {
        StringBuilder bob = new StringBuilder("http://");
        bob.append(this.getHostName());
        bob.append("/ajax/");
        bob.append(servlet);
        bob.append("?session=");
        bob.append(this.getSessionId());
        this.addParam(bob, "folder", folderId);
        this.addParam(bob, "action", format.getConstantName());
        return bob.toString();
    }

    public String getCSVColumnUrl(String servlet, int folderId, Format format) throws IOException, OXException, JSONException {
        StringBuilder bob = new StringBuilder(this.getUrl(servlet, folderId, format));
        this.addParam(bob, "columns", ContactField.GIVEN_NAME.getNumber() + "," + ContactField.EMAIL1.getNumber() + "," + ContactField.DISPLAY_NAME.getNumber());
        return bob.toString();
    }

    protected void addParam(StringBuilder bob, String param, String value) {
        bob.append('&');
        bob.append(param);
        bob.append('=');
        bob.append(value);
    }

    protected void addParam(StringBuilder bob, String param, int value) {
        this.addParam(bob, param, Integer.toString(value));
    }

    protected int createFolder(String title, int folderObjectModuleID) throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName(title);
        folderObj.setParentFolderID(1);
        folderObj.setModule(folderObjectModuleID);
        folderObj.setType(1);
        OCLPermission[] permission = new OCLPermission[]{com.openexchange.webdav.xml.FolderTest.createPermission(this.getUserId_FIXME(), false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        try {
            return com.openexchange.webdav.xml.FolderTest.insertFolder(this.getWebConversation(), folderObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        }
        catch (OXException e) {
            return -1;
        }
    }

    protected void removeFolder(int folderId) throws OXException, Exception {
        if (folderId == -1) {
            return;
        }
        com.openexchange.webdav.xml.FolderTest.deleteFolder(this.getWebConversation(), new int[]{folderId}, this.getHostName(), this.getLogin(), this.getPassword(), "");
    }

    public static void assertEquals(String message, List l1, List l2) {
        if (l1.size() != l2.size()) {
            AbstractImportExportServletTest.fail((String)message);
        }
        HashSet s = new HashSet(l1);
        for (Object o : l2) {
            AbstractImportExportServletTest.assertTrue((String)message, (boolean)s.remove(o));
        }
    }
}

