/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;

public class DistListPermissionsTest
extends AbstractManagedContactTest {
    private ContactTestManager manager2;
    private AJAXClient client2;
    private FolderTestManager folderManager2;
    private FolderObject sharedFolder;
    private Contact referencedContact1;
    private Contact referencedContact2;

    public DistListPermissionsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.manager2 = new ContactTestManager(this.client2);
        this.folderManager2 = new FolderTestManager(this.client2);
        this.sharedFolder = this.folderManager.generateSharedFolder("DistListTest_" + UUID.randomUUID().toString(), Module.CONTACTS.getFolderConstant(), this.client2.getValues().getPrivateContactFolder(), this.client2.getValues().getUserId(), this.client.getValues().getUserId());
        this.sharedFolder = this.folderManager2.insertFolderOnServer(this.sharedFolder);
        this.referencedContact1 = super.generateContact("Test1");
        this.referencedContact1.setEmail1("email1@example.com");
        this.referencedContact1.setEmail2("email2@example.com");
        this.referencedContact1.setEmail3("email3@example.com");
        this.referencedContact1.setParentFolderID(this.sharedFolder.getObjectID());
        this.referencedContact1 = this.manager2.newAction(this.referencedContact1);
        this.referencedContact2 = super.generateContact("Test2");
        this.referencedContact2.setEmail1("email1@example.org");
        this.referencedContact2.setEmail2("email2@example.org");
        this.referencedContact2.setEmail3("email3@example.org");
        this.referencedContact2.setParentFolderID(this.sharedFolder.getObjectID());
        this.referencedContact2 = this.manager2.newAction(this.referencedContact2);
    }

    @Override
    public void tearDown() throws Exception {
        this.manager2.cleanUp();
        this.folderManager2.cleanUp();
        super.tearDown();
    }

    public void testReferencedContactFromSharedFolder() throws OXException, IOException, JSONException {
        Contact distributionList = this.generateDistributionList(1, this.referencedContact1, this.referencedContact2);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)2, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)2, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1, this.referencedContact2);
    }

    public void testPrivatizeReferencedContactFromSharedFolder() throws OXException, IOException, JSONException {
        Contact distributionList = this.generateDistributionList(1, this.referencedContact1);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
        this.referencedContact1.setPrivateFlag(true);
        this.referencedContact1 = this.manager2.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListPermissionsTest.assertEquals((String)"member email address", (String)this.referencedContact1.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
    }

    public void testUnPrivatizeReferencedContactFromSharedFolder() throws OXException, IOException, JSONException {
        Contact distributionList = this.generateDistributionList(1, this.referencedContact1);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
        this.referencedContact1.setPrivateFlag(true);
        this.referencedContact1 = this.manager2.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListPermissionsTest.assertEquals((String)"member email address", (String)this.referencedContact1.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
        this.referencedContact1.setPrivateFlag(false);
        this.referencedContact1 = this.manager2.updateAction(this.referencedContact1);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
    }

    public void testRemovePermissionsForReferencedContact() throws OXException, IOException, JSONException {
        Contact distributionList = this.generateDistributionList(1, this.referencedContact1);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
        Iterator iterator = this.sharedFolder.getPermissions().iterator();
        while (iterator.hasNext()) {
            if (((OCLPermission)iterator.next()).isFolderAdmin()) continue;
            iterator.remove();
        }
        this.folderManager2.updateFolderOnServer(this.sharedFolder);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListPermissionsTest.assertEquals((String)"member email address", (String)this.referencedContact1.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
    }

    public void testGrantPermissionsForReferencedContact() throws OXException, IOException, JSONException {
        Contact distributionList = this.generateDistributionList(1, this.referencedContact1);
        distributionList = this.manager.newAction(distributionList);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
        OCLPermission removedPermission = null;
        Iterator iterator = this.sharedFolder.getPermissions().iterator();
        while (iterator.hasNext()) {
            OCLPermission permission = (OCLPermission)iterator.next();
            if (permission.isFolderAdmin()) continue;
            removedPermission = permission;
            iterator.remove();
        }
        this.sharedFolder = this.folderManager2.updateFolderOnServer(this.sharedFolder);
        this.sharedFolder.setLastModified(this.folderManager2.getLastResponse().getTimestamp());
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertEquals((String)"member mail field wrong", (int)0, (int)distributionList.getDistributionList()[0].getEmailfield());
        DistListPermissionsTest.assertEquals((String)"member email address", (String)this.referencedContact1.getEmail1(), (String)distributionList.getDistributionList()[0].getEmailaddress());
        this.sharedFolder.getPermissions().add(removedPermission);
        this.sharedFolder = this.folderManager2.updateFolderOnServer(this.sharedFolder);
        distributionList = this.manager.getAction(distributionList);
        DistListPermissionsTest.assertNotNull((String)"distibution list not found", (Object)distributionList);
        DistListPermissionsTest.assertTrue((String)"not marked as distribution list", (boolean)distributionList.getMarkAsDistribtuionlist());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getNumberOfDistributionLists());
        DistListPermissionsTest.assertEquals((String)"member count wrong", (int)1, (int)distributionList.getDistributionList().length);
        DistListPermissionsTest.assertMatches(distributionList.getDistributionList(), this.referencedContact1);
    }

    private Contact generateDistributionList(int mailField, Contact ... referencedContacts) throws OXException {
        Contact distributionList = super.generateContact("List");
        ArrayList<DistributionListEntryObject> members = new ArrayList<DistributionListEntryObject>();
        for (Contact referencedContact : referencedContacts) {
            DistributionListEntryObject member = new DistributionListEntryObject();
            member.setEntryID(referencedContact.getObjectID());
            member.setEmailfield(mailField);
            member.setFolderID(referencedContact.getParentFolderID());
            member.setDisplayname(referencedContact.getDisplayName());
            if (1 == mailField) {
                member.setEmailaddress(referencedContact.getEmail1());
            } else if (2 == mailField) {
                member.setEmailaddress(referencedContact.getEmail2());
            } else if (3 == mailField) {
                member.setEmailaddress(referencedContact.getEmail3());
            } else {
                throw new IllegalArgumentException();
            }
            members.add(member);
        }
        distributionList.setDistributionList(members.toArray(new DistributionListEntryObject[0]));
        return distributionList;
    }

    private static void assertMatches(DistributionListEntryObject[] members, Contact ... contacts) {
        for (Contact contact : contacts) {
            boolean found = false;
            for (DistributionListEntryObject member : members) {
                if (contact.getObjectID() != member.getEntryID()) continue;
                found = true;
                String referencedMail = null;
                if (1 == member.getEmailfield()) {
                    referencedMail = contact.getEmail1();
                } else if (2 == member.getEmailfield()) {
                    referencedMail = contact.getEmail2();
                } else if (3 == member.getEmailfield()) {
                    referencedMail = contact.getEmail3();
                } else {
                    DistListPermissionsTest.fail((String)"wrong mailfiled set in member");
                }
                DistListPermissionsTest.assertEquals((String)"referenced mail wrong", (String)member.getEmailaddress(), (String)referencedMail);
            }
            DistListPermissionsTest.assertTrue((String)"contact not found in distlist members", (boolean)found);
        }
    }
}

