/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;

public final class Bug21264Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone timeZone;
    private Appointment app;

    public Bug21264Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.app = new Appointment();
        this.app.setTitle("Test for bug 21264");
        Calendar cal = TimeTools.createCalendar(this.timeZone);
        this.app.setStartDate(cal.getTime());
        cal.add(10, 1);
        this.app.setEndDate(cal.getTime());
        this.app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app.setParticipants(new Participant[]{new UserParticipant(this.client.getValues().getUserId()), new ExternalUserParticipant("user1@example.org")});
        this.app.setOrganizer("user2@example.org");
        this.app.setIgnoreConflicts(true);
        AppointmentInsertResponse response = this.client.execute(new InsertRequest(this.app, this.timeZone));
        response.fillAppointment(this.app);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.app) {
            this.client.execute(new DeleteRequest(this.app));
        }
        super.tearDown();
    }

    public void testDeleteAppointment() throws IOException, JSONException, OXException {
        CommonDeleteResponse response = this.client.execute(new DeleteRequest(this.app, false));
        Bug21264Test.assertFalse((String)"Deleting appointment failed.", (boolean)response.hasError());
        this.app = null;
    }
}

